package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.TrunkBase;
import com.mypurecloud.sdk.v2.model.TrunkBaseAssignment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import java.io.Serializable;
/**
 * EdgeGroup
 */

public class EdgeGroup  implements Serializable {
  
  private String id = null;
  private String name = null;
  private Division division = null;
  private String description = null;
  private Integer version = null;
  private Date dateCreated = null;
  private Date dateModified = null;
  private String modifiedBy = null;
  private String createdBy = null;

  private static class StateEnumDeserializer extends StdDeserializer<StateEnum> {
    public StateEnumDeserializer() {
      super(StateEnumDeserializer.class);
    }

    @Override
    public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt)
            throws IOException {
      JsonNode node = jsonParser.getCodec().readTree(jsonParser);
      return StateEnum.fromString(node.toString().replace("\"", ""));
    }
  }
  /**
   * Indicates if the resource is active, inactive, or deleted.
   */
 @JsonDeserialize(using = StateEnumDeserializer.class)
  public enum StateEnum {
    OUTDATEDSDKVERSION("OutdatedSdkVersion"),
    ACTIVE("active"),
    INACTIVE("inactive"),
    DELETED("deleted");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonCreator
    public static StateEnum fromString(String key) {
      if (key == null) return null;

      for (StateEnum value : StateEnum.values()) {
        if (key.equalsIgnoreCase(value.toString())) {
          return value;
        }
      }

      return StateEnum.values()[0];
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }
  private StateEnum state = null;
  private String modifiedByApp = null;
  private String createdByApp = null;
  private Boolean managed = null;
  private Boolean hybrid = null;
  private TrunkBaseAssignment edgeTrunkBaseAssignment = null;
  private List<TrunkBase> phoneTrunkBases = new ArrayList<TrunkBase>();
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }


  /**
   * The name of the entity.
   **/
  public EdgeGroup name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The name of the entity.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }


  /**
   * The division to which this entity belongs.
   **/
  public EdgeGroup division(Division division) {
    this.division = division;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The division to which this entity belongs.")
  @JsonProperty("division")
  public Division getDivision() {
    return division;
  }
  public void setDivision(Division division) {
    this.division = division;
  }


  /**
   * The resource's description.
   **/
  public EdgeGroup description(String description) {
    this.description = description;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The resource's description.")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }


  /**
   * The current version of the resource.
   **/
  public EdgeGroup version(Integer version) {
    this.version = version;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The current version of the resource.")
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }
  public void setVersion(Integer version) {
    this.version = version;
  }


  @ApiModelProperty(example = "null", value = "The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
  @JsonProperty("dateCreated")
  public Date getDateCreated() {
    return dateCreated;
  }


  @ApiModelProperty(example = "null", value = "The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
  @JsonProperty("dateModified")
  public Date getDateModified() {
    return dateModified;
  }


  @ApiModelProperty(example = "null", value = "The ID of the user that last modified the resource.")
  @JsonProperty("modifiedBy")
  public String getModifiedBy() {
    return modifiedBy;
  }


  @ApiModelProperty(example = "null", value = "The ID of the user that created the resource.")
  @JsonProperty("createdBy")
  public String getCreatedBy() {
    return createdBy;
  }


  @ApiModelProperty(example = "null", value = "Indicates if the resource is active, inactive, or deleted.")
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }


  @ApiModelProperty(example = "null", value = "The application that last modified the resource.")
  @JsonProperty("modifiedByApp")
  public String getModifiedByApp() {
    return modifiedByApp;
  }


  @ApiModelProperty(example = "null", value = "The application that created the resource.")
  @JsonProperty("createdByApp")
  public String getCreatedByApp() {
    return createdByApp;
  }


  /**
   * Is this edge group being managed remotely.
   **/
  public EdgeGroup managed(Boolean managed) {
    this.managed = managed;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Is this edge group being managed remotely.")
  @JsonProperty("managed")
  public Boolean getManaged() {
    return managed;
  }
  public void setManaged(Boolean managed) {
    this.managed = managed;
  }


  /**
   * Is this edge group hybrid.
   **/
  public EdgeGroup hybrid(Boolean hybrid) {
    this.hybrid = hybrid;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Is this edge group hybrid.")
  @JsonProperty("hybrid")
  public Boolean getHybrid() {
    return hybrid;
  }
  public void setHybrid(Boolean hybrid) {
    this.hybrid = hybrid;
  }


  /**
   * A trunk base settings assignment of trunkType \"EDGE\" to use for edge-to-edge communication.
   **/
  public EdgeGroup edgeTrunkBaseAssignment(TrunkBaseAssignment edgeTrunkBaseAssignment) {
    this.edgeTrunkBaseAssignment = edgeTrunkBaseAssignment;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "A trunk base settings assignment of trunkType \"EDGE\" to use for edge-to-edge communication.")
  @JsonProperty("edgeTrunkBaseAssignment")
  public TrunkBaseAssignment getEdgeTrunkBaseAssignment() {
    return edgeTrunkBaseAssignment;
  }
  public void setEdgeTrunkBaseAssignment(TrunkBaseAssignment edgeTrunkBaseAssignment) {
    this.edgeTrunkBaseAssignment = edgeTrunkBaseAssignment;
  }


  /**
   * Trunk base settings of trunkType \"PHONE\" to inherit to edge logical interface for phone communication.
   **/
  public EdgeGroup phoneTrunkBases(List<TrunkBase> phoneTrunkBases) {
    this.phoneTrunkBases = phoneTrunkBases;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Trunk base settings of trunkType \"PHONE\" to inherit to edge logical interface for phone communication.")
  @JsonProperty("phoneTrunkBases")
  public List<TrunkBase> getPhoneTrunkBases() {
    return phoneTrunkBases;
  }
  public void setPhoneTrunkBases(List<TrunkBase> phoneTrunkBases) {
    this.phoneTrunkBases = phoneTrunkBases;
  }


  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EdgeGroup edgeGroup = (EdgeGroup) o;

    return Objects.equals(this.id, edgeGroup.id) &&
            Objects.equals(this.name, edgeGroup.name) &&
            Objects.equals(this.division, edgeGroup.division) &&
            Objects.equals(this.description, edgeGroup.description) &&
            Objects.equals(this.version, edgeGroup.version) &&
            Objects.equals(this.dateCreated, edgeGroup.dateCreated) &&
            Objects.equals(this.dateModified, edgeGroup.dateModified) &&
            Objects.equals(this.modifiedBy, edgeGroup.modifiedBy) &&
            Objects.equals(this.createdBy, edgeGroup.createdBy) &&
            Objects.equals(this.state, edgeGroup.state) &&
            Objects.equals(this.modifiedByApp, edgeGroup.modifiedByApp) &&
            Objects.equals(this.createdByApp, edgeGroup.createdByApp) &&
            Objects.equals(this.managed, edgeGroup.managed) &&
            Objects.equals(this.hybrid, edgeGroup.hybrid) &&
            Objects.equals(this.edgeTrunkBaseAssignment, edgeGroup.edgeTrunkBaseAssignment) &&
            Objects.equals(this.phoneTrunkBases, edgeGroup.phoneTrunkBases) &&
            Objects.equals(this.selfUri, edgeGroup.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, division, description, version, dateCreated, dateModified, modifiedBy, createdBy, state, modifiedByApp, createdByApp, managed, hybrid, edgeTrunkBaseAssignment, phoneTrunkBases, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EdgeGroup {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    division: ").append(toIndentedString(division)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    dateCreated: ").append(toIndentedString(dateCreated)).append("\n");
    sb.append("    dateModified: ").append(toIndentedString(dateModified)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    modifiedByApp: ").append(toIndentedString(modifiedByApp)).append("\n");
    sb.append("    createdByApp: ").append(toIndentedString(createdByApp)).append("\n");
    sb.append("    managed: ").append(toIndentedString(managed)).append("\n");
    sb.append("    hybrid: ").append(toIndentedString(hybrid)).append("\n");
    sb.append("    edgeTrunkBaseAssignment: ").append(toIndentedString(edgeTrunkBaseAssignment)).append("\n");
    sb.append("    phoneTrunkBases: ").append(toIndentedString(phoneTrunkBases)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

