/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetCoachingAppointmentsRequest {
    private List<String> userIds;
    private String interval;
    private Integer pageNumber;
    private Integer pageSize;
    private List<String> statuses;
    private List<String> facilitatorIds;
    private String sortOrder;
    private List<String> relationships;
    private String completionInterval;
    private String overdue;
    private String intervalCondition;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public GetCoachingAppointmentsRequest withUserIds(List<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public GetCoachingAppointmentsRequest withInterval(String interval) {
        this.setInterval(interval);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetCoachingAppointmentsRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetCoachingAppointmentsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses = statuses;
    }

    public GetCoachingAppointmentsRequest withStatuses(List<String> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public List<String> getFacilitatorIds() {
        return this.facilitatorIds;
    }

    public void setFacilitatorIds(List<String> facilitatorIds) {
        this.facilitatorIds = facilitatorIds;
    }

    public GetCoachingAppointmentsRequest withFacilitatorIds(List<String> facilitatorIds) {
        this.setFacilitatorIds(facilitatorIds);
        return this;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public GetCoachingAppointmentsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public List<String> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<String> relationships) {
        this.relationships = relationships;
    }

    public GetCoachingAppointmentsRequest withRelationships(List<String> relationships) {
        this.setRelationships(relationships);
        return this;
    }

    public String getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(String completionInterval) {
        this.completionInterval = completionInterval;
    }

    public GetCoachingAppointmentsRequest withCompletionInterval(String completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public String getOverdue() {
        return this.overdue;
    }

    public void setOverdue(String overdue) {
        this.overdue = overdue;
    }

    public GetCoachingAppointmentsRequest withOverdue(String overdue) {
        this.setOverdue(overdue);
        return this;
    }

    public String getIntervalCondition() {
        return this.intervalCondition;
    }

    public void setIntervalCondition(String intervalCondition) {
        this.intervalCondition = intervalCondition;
    }

    public GetCoachingAppointmentsRequest withIntervalCondition(String intervalCondition) {
        this.setIntervalCondition(intervalCondition);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetCoachingAppointmentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userIds == null) {
            throw new IllegalStateException("Missing the required parameter 'userIds' when building request for GetCoachingAppointmentsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/coaching/appointments").withQueryParameters("userIds", "multi", this.userIds).withQueryParameters("interval", "", this.interval).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("statuses", "multi", this.statuses).withQueryParameters("facilitatorIds", "multi", this.facilitatorIds).withQueryParameters("sortOrder", "", this.sortOrder).withQueryParameters("relationships", "multi", this.relationships).withQueryParameters("completionInterval", "", this.completionInterval).withQueryParameters("overdue", "", this.overdue).withQueryParameters("intervalCondition", "", this.intervalCondition).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> userIds) {
        return new Builder().withRequiredParams(userIds);
    }

    public static class Builder {
        private final GetCoachingAppointmentsRequest request = new GetCoachingAppointmentsRequest();

        private Builder() {
        }

        public Builder withUserIds(List<String> userIds) {
            this.request.setUserIds(userIds);
            return this;
        }

        public Builder withInterval(String interval) {
            this.request.setInterval(interval);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withStatuses(List<String> statuses) {
            this.request.setStatuses(statuses);
            return this;
        }

        public Builder withStatusesEnumValues(List<statusesValues> statuses) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (statusesValues e : statuses) {
                stringList.add(e.toString());
            }
            this.request.setStatuses(stringList);
            return this;
        }

        public Builder withFacilitatorIds(List<String> facilitatorIds) {
            this.request.setFacilitatorIds(facilitatorIds);
            return this;
        }

        public Builder withSortOrder(String sortOrder) {
            this.request.setSortOrder(sortOrder);
            return this;
        }

        public Builder withSortOrder(sortOrderValues sortOrder) {
            this.request.setSortOrder(sortOrder.toString());
            return this;
        }

        public Builder withRelationships(List<String> relationships) {
            this.request.setRelationships(relationships);
            return this;
        }

        public Builder withRelationshipsEnumValues(List<relationshipsValues> relationships) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (relationshipsValues e : relationships) {
                stringList.add(e.toString());
            }
            this.request.setRelationships(stringList);
            return this;
        }

        public Builder withCompletionInterval(String completionInterval) {
            this.request.setCompletionInterval(completionInterval);
            return this;
        }

        public Builder withOverdue(String overdue) {
            this.request.setOverdue(overdue);
            return this;
        }

        public Builder withOverdue(overdueValues overdue) {
            this.request.setOverdue(overdue.toString());
            return this;
        }

        public Builder withIntervalCondition(String intervalCondition) {
            this.request.setIntervalCondition(intervalCondition);
            return this;
        }

        public Builder withIntervalCondition(intervalConditionValues intervalCondition) {
            this.request.setIntervalCondition(intervalCondition.toString());
            return this;
        }

        public Builder withRequiredParams(List<String> userIds) {
            this.request.setUserIds(userIds);
            return this;
        }

        public GetCoachingAppointmentsRequest build() {
            if (this.request.userIds == null) {
                throw new IllegalStateException("Missing the required parameter 'userIds' when building request for GetCoachingAppointmentsRequest.");
            }
            return this.request;
        }
    }

    public static enum intervalConditionValues {
        STARTSIN("StartsIn"),
        OVERLAPS("Overlaps");

        private String value;

        private intervalConditionValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static intervalConditionValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (intervalConditionValues value : intervalConditionValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return intervalConditionValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum overdueValues {
        TRUE("True"),
        FALSE("False"),
        ANY("Any");

        private String value;

        private overdueValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static overdueValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (overdueValues value : overdueValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return overdueValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum relationshipsValues {
        CREATOR("Creator"),
        FACILITATOR("Facilitator"),
        ATTENDEE("Attendee");

        private String value;

        private relationshipsValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static relationshipsValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (relationshipsValues value : relationshipsValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return relationshipsValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum sortOrderValues {
        DESC("Desc"),
        ASC("Asc");

        private String value;

        private sortOrderValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static sortOrderValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (sortOrderValues value : sortOrderValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return sortOrderValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum statusesValues {
        SCHEDULED("Scheduled"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private statusesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static statusesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (statusesValues value : statusesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return statusesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

