/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class GetGamificationProfilesUserRequest {
    private String userId;
    private LocalDate workday;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetGamificationProfilesUserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public LocalDate getWorkday() {
        return this.workday;
    }

    public void setWorkday(LocalDate workday) {
        this.workday = workday;
    }

    public GetGamificationProfilesUserRequest withWorkday(LocalDate workday) {
        this.setWorkday(workday);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGamificationProfilesUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetGamificationProfilesUserRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/gamification/profiles/users/{userId}").withPathParameter("userId", this.userId).withQueryParameters("workday", "", this.workday).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetGamificationProfilesUserRequest request = new GetGamificationProfilesUserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withWorkday(LocalDate workday) {
            this.request.setWorkday(workday);
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetGamificationProfilesUserRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetGamificationProfilesUserRequest.");
            }
            return this.request;
        }
    }
}

