/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SuggestionEngagement;
import java.util.HashMap;
import java.util.Map;

public class PostConversationSuggestionEngagementRequest {
    private String conversationId;
    private String suggestionId;
    private SuggestionEngagement body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationSuggestionEngagementRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getSuggestionId() {
        return this.suggestionId;
    }

    public void setSuggestionId(String suggestionId) {
        this.suggestionId = suggestionId;
    }

    public PostConversationSuggestionEngagementRequest withSuggestionId(String suggestionId) {
        this.setSuggestionId(suggestionId);
        return this;
    }

    public SuggestionEngagement getBody() {
        return this.body;
    }

    public void setBody(SuggestionEngagement body) {
        this.body = body;
    }

    public PostConversationSuggestionEngagementRequest withBody(SuggestionEngagement body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationSuggestionEngagementRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SuggestionEngagement> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationSuggestionEngagementRequest.");
        }
        if (this.suggestionId == null) {
            throw new IllegalStateException("Missing the required parameter 'suggestionId' when building request for PostConversationSuggestionEngagementRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationSuggestionEngagementRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/{conversationId}/suggestions/{suggestionId}/engagement").withPathParameter("conversationId", this.conversationId).withPathParameter("suggestionId", this.suggestionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String suggestionId, SuggestionEngagement body) {
        return new Builder().withRequiredParams(conversationId, suggestionId, body);
    }

    public static class Builder {
        private final PostConversationSuggestionEngagementRequest request = new PostConversationSuggestionEngagementRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withSuggestionId(String suggestionId) {
            this.request.setSuggestionId(suggestionId);
            return this;
        }

        public Builder withBody(SuggestionEngagement body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String suggestionId, SuggestionEngagement body) {
            this.request.setConversationId(conversationId);
            this.request.setSuggestionId(suggestionId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationSuggestionEngagementRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationSuggestionEngagementRequest.");
            }
            if (this.request.suggestionId == null) {
                throw new IllegalStateException("Missing the required parameter 'suggestionId' when building request for PostConversationSuggestionEngagementRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationSuggestionEngagementRequest.");
            }
            return this.request;
        }
    }
}

