/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AgentBidWorkPlanOverrideRequest
implements Serializable {
    private String agentId = null;
    private String overrideWorkPlanId = null;
    private OverrideReasonEnum overrideReason = null;

    public AgentBidWorkPlanOverrideRequest agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of agent")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public AgentBidWorkPlanOverrideRequest overrideWorkPlanId(String overrideWorkPlanId) {
        this.overrideWorkPlanId = overrideWorkPlanId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the work plan that overrides the assigned work plan for the agent")
    @JsonProperty(value="overrideWorkPlanId")
    public String getOverrideWorkPlanId() {
        return this.overrideWorkPlanId;
    }

    public void setOverrideWorkPlanId(String overrideWorkPlanId) {
        this.overrideWorkPlanId = overrideWorkPlanId;
    }

    public AgentBidWorkPlanOverrideRequest overrideReason(OverrideReasonEnum overrideReason) {
        this.overrideReason = overrideReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason for overriding the assigned work plan. This must be null if overrideWorkPlanId is not specified")
    @JsonProperty(value="overrideReason")
    public OverrideReasonEnum getOverrideReason() {
        return this.overrideReason;
    }

    public void setOverrideReason(OverrideReasonEnum overrideReason) {
        this.overrideReason = overrideReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentBidWorkPlanOverrideRequest agentBidWorkPlanOverrideRequest = (AgentBidWorkPlanOverrideRequest)o;
        return Objects.equals(this.agentId, agentBidWorkPlanOverrideRequest.agentId) && Objects.equals(this.overrideWorkPlanId, agentBidWorkPlanOverrideRequest.overrideWorkPlanId) && Objects.equals((Object)this.overrideReason, (Object)agentBidWorkPlanOverrideRequest.overrideReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agentId, this.overrideWorkPlanId, this.overrideReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentBidWorkPlanOverrideRequest {\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    overrideWorkPlanId: ").append(this.toIndentedString(this.overrideWorkPlanId)).append("\n");
        sb.append("    overrideReason: ").append(this.toIndentedString((Object)this.overrideReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OverrideReasonEnumDeserializer.class)
    public static enum OverrideReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNABLETOBID("UnableToBid"),
        CHANGEOFCIRCUMSTANCE("ChangeOfCircumstance"),
        NEWHIRE("NewHire"),
        EMPLOYEEMOVE("EmployeeMove");

        private String value;

        private OverrideReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverrideReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OverrideReasonEnum value : OverrideReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OverrideReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OverrideReasonEnumDeserializer
    extends StdDeserializer<OverrideReasonEnum> {
        public OverrideReasonEnumDeserializer() {
            super(OverrideReasonEnumDeserializer.class);
        }

        public OverrideReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OverrideReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

