/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CallToAction
implements Serializable {
    private String text = null;
    private String url = null;
    private TargetEnum target = null;

    public CallToAction text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text displayed on the call to action button.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CallToAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL to open when user clicks on the call to action button.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CallToAction target(TargetEnum target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="null", value="Where the URL should be opened when the user clicks on the call to action button.")
    @JsonProperty(value="target")
    public TargetEnum getTarget() {
        return this.target;
    }

    public void setTarget(TargetEnum target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallToAction callToAction = (CallToAction)o;
        return Objects.equals(this.text, callToAction.text) && Objects.equals(this.url, callToAction.url) && Objects.equals((Object)this.target, (Object)callToAction.target);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.url, this.target});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallToAction {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    target: ").append(this.toIndentedString((Object)this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TargetEnumDeserializer.class)
    public static enum TargetEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BLANK("Blank"),
        SELF("Self");

        private String value;

        private TargetEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TargetEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TargetEnum value : TargetEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TargetEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TargetEnumDeserializer
    extends StdDeserializer<TargetEnum> {
        public TargetEnumDeserializer() {
            super(TargetEnumDeserializer.class);
        }

        public TargetEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TargetEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

