/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WorkitemQueryJobFilter;
import com.mypurecloud.sdk.v2.model.WorkitemQueryJobSort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkitemQueryJobCreate
implements Serializable {
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<WorkitemQueryJobFilter> filters = new ArrayList<WorkitemQueryJobFilter>();
    private List<ExpandsEnum> expands = new ArrayList<ExpandsEnum>();
    private List<String> attributes = new ArrayList<String>();
    private WorkitemQueryJobSort sort = null;

    public WorkitemQueryJobCreate pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The total page size requested. Default 25")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public WorkitemQueryJobCreate pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page number requested")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public WorkitemQueryJobCreate filters(List<WorkitemQueryJobFilter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of filter objects to be used in the search.")
    @JsonProperty(value="filters")
    public List<WorkitemQueryJobFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WorkitemQueryJobFilter> filters) {
        this.filters = filters;
    }

    public WorkitemQueryJobCreate expands(List<ExpandsEnum> expands) {
        this.expands = expands;
        return this;
    }

    @ApiModelProperty(example="null", value="List of entity attributes to be expanded in the result.")
    @JsonProperty(value="expands")
    public List<ExpandsEnum> getExpands() {
        return this.expands;
    }

    public void setExpands(List<ExpandsEnum> expands) {
        this.expands = expands;
    }

    public WorkitemQueryJobCreate attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="List of entity attributes to be retrieved in the result.")
    @JsonProperty(value="attributes")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public WorkitemQueryJobCreate sort(WorkitemQueryJobSort sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort")
    @JsonProperty(value="sort")
    public WorkitemQueryJobSort getSort() {
        return this.sort;
    }

    public void setSort(WorkitemQueryJobSort sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemQueryJobCreate workitemQueryJobCreate = (WorkitemQueryJobCreate)o;
        return Objects.equals(this.pageSize, workitemQueryJobCreate.pageSize) && Objects.equals(this.pageNumber, workitemQueryJobCreate.pageNumber) && Objects.equals(this.filters, workitemQueryJobCreate.filters) && Objects.equals(this.expands, workitemQueryJobCreate.expands) && Objects.equals(this.attributes, workitemQueryJobCreate.attributes) && Objects.equals(this.sort, workitemQueryJobCreate.sort);
    }

    public int hashCode() {
        return Objects.hash(this.pageSize, this.pageNumber, this.filters, this.expands, this.attributes, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemQueryJobCreate {\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    expands: ").append(this.toIndentedString(this.expands)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ExpandsEnumDeserializer.class)
    public static enum ExpandsEnum {
        TYPE("type"),
        WORKBIN("workbin"),
        STATUS("status"),
        ASSIGNEE("assignee"),
        REPORTER("reporter"),
        QUEUE("queue");

        private String value;

        private ExpandsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExpandsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExpandsEnum value : ExpandsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExpandsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ExpandsEnumDeserializer
    extends StdDeserializer<ExpandsEnum> {
        public ExpandsEnumDeserializer() {
            super(ExpandsEnumDeserializer.class);
        }

        public ExpandsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExpandsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

