/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneySessionEventsRequest {
    private String sessionId;
    private String pageSize;
    private String after;
    private String eventType;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public GetJourneySessionEventsRequest withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public GetJourneySessionEventsRequest withPageSize(String pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public GetJourneySessionEventsRequest withAfter(String after) {
        this.setAfter(after);
        return this;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public GetJourneySessionEventsRequest withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneySessionEventsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.sessionId == null) {
            throw new IllegalStateException("Missing the required parameter 'sessionId' when building request for GetJourneySessionEventsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/sessions/{sessionId}/events").withPathParameter("sessionId", this.sessionId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("after", "", this.after).withQueryParameters("eventType", "", this.eventType).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sessionId) {
        return new Builder().withRequiredParams(sessionId);
    }

    public static class Builder {
        private final GetJourneySessionEventsRequest request = new GetJourneySessionEventsRequest();

        private Builder() {
        }

        public Builder withSessionId(String sessionId) {
            this.request.setSessionId(sessionId);
            return this;
        }

        public Builder withPageSize(String pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withAfter(String after) {
            this.request.setAfter(after);
            return this;
        }

        public Builder withEventType(String eventType) {
            this.request.setEventType(eventType);
            return this;
        }

        public Builder withEventType(eventTypeValues eventType) {
            this.request.setEventType(eventType.toString());
            return this;
        }

        public Builder withRequiredParams(String sessionId) {
            this.request.setSessionId(sessionId);
            return this;
        }

        public GetJourneySessionEventsRequest build() {
            if (this.request.sessionId == null) {
                throw new IllegalStateException("Missing the required parameter 'sessionId' when building request for GetJourneySessionEventsRequest.");
            }
            return this.request;
        }
    }

    public static enum eventTypeValues {
        COM_GENESYS_JOURNEY_OUTCOMEACHIEVEDEVENT("com.genesys.journey.OutcomeAchievedEvent"),
        COM_GENESYS_JOURNEY_SEGMENTASSIGNMENTEVENT("com.genesys.journey.SegmentAssignmentEvent"),
        COM_GENESYS_JOURNEY_WEBACTIONEVENT("com.genesys.journey.WebActionEvent"),
        COM_GENESYS_JOURNEY_WEBEVENT("com.genesys.journey.WebEvent"),
        COM_GENESYS_JOURNEY_APPEVENT("com.genesys.journey.AppEvent");

        private String value;

        private eventTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static eventTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (eventTypeValues value : eventTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return eventTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

