/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AssistantQueue;
import java.util.HashMap;
import java.util.Map;

public class PutAssistantQueueRequest {
    private String assistantId;
    private String queueId;
    private AssistantQueue body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PutAssistantQueueRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PutAssistantQueueRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public AssistantQueue getBody() {
        return this.body;
    }

    public void setBody(AssistantQueue body) {
        this.body = body;
    }

    public PutAssistantQueueRequest withBody(AssistantQueue body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAssistantQueueRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AssistantQueue> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PutAssistantQueueRequest.");
        }
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PutAssistantQueueRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAssistantQueueRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/assistants/{assistantId}/queues/{queueId}").withPathParameter("assistantId", this.assistantId).withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, String queueId, AssistantQueue body) {
        return new Builder().withRequiredParams(assistantId, queueId, body);
    }

    public static class Builder {
        private final PutAssistantQueueRequest request = new PutAssistantQueueRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(AssistantQueue body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, String queueId, AssistantQueue body) {
            this.request.setAssistantId(assistantId);
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PutAssistantQueueRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PutAssistantQueueRequest.");
            }
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PutAssistantQueueRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAssistantQueueRequest.");
            }
            return this.request;
        }
    }
}

