/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConversationAssociation
implements Serializable {
    private String externalContactId = null;
    private String conversationId = null;
    private String communicationId = null;
    private MediaTypeEnum mediaType = null;

    public ConversationAssociation externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="An external contact ID.  If not supplied, implies the conversation should be disassociated with any external contact.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public ConversationAssociation conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Conversation ID")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public ConversationAssociation communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Communication ID")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public ConversationAssociation mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Media type")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationAssociation conversationAssociation = (ConversationAssociation)o;
        return Objects.equals(this.externalContactId, conversationAssociation.externalContactId) && Objects.equals(this.conversationId, conversationAssociation.conversationId) && Objects.equals(this.communicationId, conversationAssociation.communicationId) && Objects.equals((Object)this.mediaType, (Object)conversationAssociation.mediaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalContactId, this.conversationId, this.communicationId, this.mediaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationAssociation {\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("CALL"),
        CALLBACK("CALLBACK"),
        CHAT("CHAT"),
        COBROWSE("COBROWSE"),
        EMAIL("EMAIL"),
        MESSAGE("MESSAGE"),
        INTERNAL_MESSAGE("INTERNAL_MESSAGE"),
        SOCIAL_EXPRESSION("SOCIAL_EXPRESSION"),
        VIDEO("VIDEO"),
        SCREENSHARE("SCREENSHARE");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

