/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A WhatsApp messaging template definition as defined in the WhatsApp Business Manager")
public class WhatsAppDefinition
implements Serializable {
    private String name = null;
    private String namespace = null;
    private String language = null;

    public WhatsAppDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging template name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsAppDefinition namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging template namespace.")
    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public WhatsAppDefinition language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging template language configured for this template. This is a WhatsApp specific value. For example, 'en_US'")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppDefinition whatsAppDefinition = (WhatsAppDefinition)o;
        return Objects.equals(this.name, whatsAppDefinition.name) && Objects.equals(this.namespace, whatsAppDefinition.namespace) && Objects.equals(this.language, whatsAppDefinition.language);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.language);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

