/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.maven.apt;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractProcessorMojo
extends AbstractMojo {
    private static final String JAVA_FILE_FILTER = "/*.java";
    private static final String[] ALL_JAVA_FILES_FILTER = new String[]{"**/*.java"};
    private BuildContext buildContext;
    private MavenProject project;
    private String[] processors;
    private String processor;
    private String sourceEncoding;
    private Map<String, String> options;
    private Map<String, String> compilerOptions;
    private Set<String> includes = new HashSet<String>();
    private boolean showWarnings = false;
    private boolean logOnlyOnError = false;
    private List<Artifact> pluginArtifacts;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.isForTest() ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            super.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                if (a.getFile() == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append((String)pathElements.get(i)).append(File.pathSeparatorChar);
        }
        result.append((String)pathElements.get(i));
        return result.toString();
    }

    private String buildProcessor() {
        if (this.processors != null) {
            StringBuilder result = new StringBuilder();
            for (String processor : this.processors) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(processor);
            }
            return result.toString();
        }
        if (this.processor != null) {
            return this.processor;
        }
        String error = "Either processor or processors need to be given";
        this.getLog().error((CharSequence)error);
        throw new IllegalArgumentException(error);
    }

    private List<String> buildCompilerOptions(String processor, String compileClassPath) throws IOException {
        LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
        compilerOpts.put("cp", compileClassPath);
        if (this.sourceEncoding != null) {
            compilerOpts.put("encoding", this.sourceEncoding);
        }
        compilerOpts.put("proc:only", null);
        compilerOpts.put("processor", processor);
        if (this.options != null) {
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                compilerOpts.put("A" + entry.getKey() + "=" + entry.getValue(), null);
            }
        }
        if (this.getOutputDirectory() != null) {
            compilerOpts.put("s", this.getOutputDirectory().getPath());
        }
        if (!this.showWarnings) {
            compilerOpts.put("nowarn", null);
        }
        StringBuilder builder = new StringBuilder();
        for (File file : this.getSourceDirectories()) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(file.getCanonicalPath());
        }
        compilerOpts.put("sourcepath", builder.toString());
        if (this.compilerOptions != null) {
            compilerOpts.putAll(this.compilerOptions);
        }
        ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
        for (Map.Entry compilerOption : compilerOpts.entrySet()) {
            opts.add("-" + (String)compilerOption.getKey());
            String value = (String)compilerOption.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            opts.add(value);
        }
        return opts;
    }

    private Set<File> filterFiles(Set<File> directories) {
        String[] filters = ALL_JAVA_FILES_FILTER;
        if (this.includes != null && !this.includes.isEmpty()) {
            filters = this.includes.toArray(new String[this.includes.size()]);
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = filters[i].replace('.', '/') + JAVA_FILE_FILTER;
            }
        }
        HashSet<File> files = new HashSet<File>();
        for (File directory : directories) {
            Scanner scanner = this.buildContext.newScanner(directory);
            scanner.setIncludes(filters);
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (includedFiles == null) continue;
            for (String includedFile : includedFiles) {
                files.add(new File(scanner.getBasedir(), includedFile));
            }
        }
        return files;
    }

    public void execute() throws MojoExecutionException {
        if (this.getOutputDirectory() == null) {
            return;
        }
        if (!this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        } else {
            this.project.addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        }
        Set<File> sourceDirectories = this.getSourceDirectories();
        this.getLog().debug((CharSequence)("Using build context: " + this.buildContext));
        JavaFileManager fileManager = null;
        try {
            JavaCompiler.CompilationTask task;
            Boolean rv;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new MojoExecutionException("You need to run build with JDK or have tools.jar on the classpath.If this occures during eclipse build make sure you run eclipse under JDK as well");
            }
            Set<File> files = this.filterFiles(sourceDirectories);
            if (files.isEmpty()) {
                this.getLog().debug((CharSequence)"There is no sources to generatate querydsl classes from (skipping)");
                return;
            }
            fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            String compileClassPath = this.buildCompileClasspath();
            String processor = this.buildProcessor();
            List<String> compilerOptions = this.buildCompilerOptions(processor, compileClassPath);
            StringWriter out = null;
            if (this.logOnlyOnError) {
                out = new StringWriter();
            }
            if (Boolean.FALSE.equals(rv = (task = compiler.getTask(out, fileManager, null, compilerOptions, null, compilationUnits1)).call()) && this.logOnlyOnError) {
                this.getLog().error((CharSequence)((Object)out).toString());
            }
            this.buildContext.refresh(this.getOutputDirectory());
        }
        catch (Exception e1) {
            this.getLog().error((CharSequence)"execute error", (Throwable)e1);
            throw new MojoExecutionException(e1.getMessage(), e1);
        }
        finally {
            if (fileManager != null) {
                try {
                    fileManager.close();
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Unable to close fileManager", (Throwable)e);
                }
            }
        }
    }

    protected abstract File getOutputDirectory();

    protected Set<File> getSourceDirectories() {
        File outputDirectory = this.getOutputDirectory();
        HashSet<File> directories = new HashSet<File>();
        List directoryNames = this.isForTest() ? this.project.getTestCompileSourceRoots() : this.project.getCompileSourceRoots();
        for (String name : directoryNames) {
            File file = new File(name);
            if (file.equals(outputDirectory) || !file.exists()) continue;
            directories.add(file);
        }
        return directories;
    }

    protected boolean isForTest() {
        return false;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setProcessors(String[] processors) {
        this.processors = processors;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void setCompilerOptions(Map<String, String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public void setLogOnlyOnError(boolean logOnlyOnError) {
        this.logOnlyOnError = logOnlyOnError;
    }

    public void setPluginArtifacts(List<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }
}

