/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.maven.dbmaintain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dbmaintain.launch.DbMaintain;

public abstract class AbstractDbMaintainMojo
extends AbstractMojo {
    protected String configFile;
    private Map<String, String> properties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(this.configFile)));
            if (this.properties != null) {
                for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                    properties.put(entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                if (!entry.getKey().toString().startsWith("database.")) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
            this.execute(new DbMaintain(properties));
        }
        catch (MalformedURLException e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void execute(DbMaintain var1);
}

