/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers.matrix;

import it.uniroma3.mat.extendedset.AbstractExtendedSet;
import it.uniroma3.mat.extendedset.ExtendedSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import it.uniroma3.mat.extendedset.wrappers.IndexedSet;
import it.uniroma3.mat.extendedset.wrappers.IntegerSet;
import it.uniroma3.mat.extendedset.wrappers.matrix.BinaryMatrix;
import it.uniroma3.mat.extendedset.wrappers.matrix.Pair;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class PairSet<T, I>
extends AbstractExtendedSet<Pair<T, I>>
implements Serializable {
    private static final long serialVersionUID = 7902458899512666217L;
    private final BinaryMatrix matrix;
    private final IndexedSet<T> allTransactions;
    private final IndexedSet<I> allItems;

    private int transactionToIndex(T t) {
        Integer r = this.allTransactions.absoluteIndexOf(t);
        return r == null ? -1 : r;
    }

    private int itemToIndex(I i) {
        Integer r = this.allItems.absoluteIndexOf(i);
        return r == null ? -1 : r;
    }

    private Pair<T, I> indexToPair(int[] i) {
        return new Pair<T, I>(this.allTransactions.absoluteGet(i[0]), this.allItems.absoluteGet(i[1]));
    }

    public PairSet(BinaryMatrix matrix, Collection<T> transactions, Collection<I> items) {
        if (transactions == null || items == null) {
            throw new NullPointerException();
        }
        this.matrix = matrix;
        IntSet tmp = matrix.emptyRow();
        this.allTransactions = transactions instanceof IndexedSet ? (IndexedSet)transactions : new IndexedSet<T>(tmp.empty(), transactions).universe();
        this.allItems = items instanceof IndexedSet ? (IndexedSet<Object>)items : new IndexedSet<I>(tmp.empty(), items).universe();
    }

    public PairSet(BinaryMatrix matrix, final Object[][] pairs) {
        this(matrix, new AbstractCollection<Pair<T, I>>(){

            @Override
            public Iterator<Pair<T, I>> iterator() {
                return new Iterator<Pair<T, I>>(){
                    int i = 0;

                    @Override
                    public Pair<T, I> next() {
                        return new Pair<Object, Object>(pairs[this.i][0], pairs[this.i++][1]);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < pairs.length;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return pairs.length;
            }
        });
    }

    public PairSet(BinaryMatrix matrix, Collection<? extends Pair<T, I>> pairs) {
        if (pairs == null) {
            throw new RuntimeException("null pair set");
        }
        if (pairs.isEmpty()) {
            throw new RuntimeException("empty pair set");
        }
        final HashMap ts = new HashMap();
        final HashMap is = new HashMap();
        for (Pair<T, I> p : pairs) {
            Integer f = (Integer)ts.get(p.transaction);
            f = f == null ? 1 : f + 1;
            ts.put(p.transaction, f);
            f = (Integer)is.get(p.item);
            f = f == null ? 1 : f + 1;
            is.put(p.item, f);
        }
        ArrayList<Pair<T, I>> sortedPairs = new ArrayList<Pair<T, I>>(pairs);
        Collections.sort(sortedPairs, new Comparator<Pair<T, I>>(){

            @Override
            public int compare(Pair<T, I> o1, Pair<T, I> o2) {
                int r = ((Integer)ts.get(o2.transaction)).compareTo((Integer)ts.get(o1.transaction));
                if (r == 0) {
                    r = ((Integer)is.get(o2.item)).compareTo((Integer)is.get(o1.item));
                }
                return r;
            }
        });
        ArrayList sortedTransactions = new ArrayList(ts.keySet());
        Collections.sort(sortedTransactions, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Integer)ts.get(o2)).compareTo((Integer)ts.get(o1));
            }
        });
        ArrayList sortedItems = new ArrayList(is.keySet());
        Collections.sort(sortedItems, new Comparator<I>(){

            @Override
            public int compare(I o1, I o2) {
                return ((Integer)is.get(o2)).compareTo((Integer)is.get(o1));
            }
        });
        this.matrix = matrix;
        matrix.add(0, 0);
        this.allTransactions = new IndexedSet(matrix.getRow(0), sortedTransactions).universe();
        this.allItems = new IndexedSet(matrix.getRow(0), sortedItems).universe();
        matrix.clear();
        for (Pair pair : sortedPairs) {
            this.add(pair);
        }
    }

    public static PairSet<Integer, Integer> createFromBinaryMatrix(BinaryMatrix b) {
        IntegerSet t = new IntegerSet(b.emptyRow());
        t.intSet().add(b.maxRow() + 1);
        t.intSet().complement();
        IntegerSet i = new IntegerSet(b.emptyRow());
        i.intSet().add(b.maxCol() + 1);
        i.intSet().complement();
        return new PairSet<Integer, Integer>(b, t, i);
    }

    private PairSet<T, I> createFromIndices(BinaryMatrix bm) {
        return new PairSet<T, I>(bm, this.allTransactions, this.allItems);
    }

    @Override
    public PairSet<T, I> clone() {
        return this.createFromIndices(this.matrix.clone());
    }

    private boolean hasSameIndices(Collection<?> c) {
        return c != null && c instanceof PairSet && this.allTransactions == ((PairSet)c).allTransactions && this.allItems == ((PairSet)c).allItems;
    }

    @Override
    public boolean add(Pair<T, I> e) {
        return this.add(e.transaction, e.item);
    }

    public boolean add(T transaction, I item) {
        return this.matrix.add(this.transactionToIndex(transaction), this.itemToIndex(item));
    }

    @Override
    public boolean addAll(Collection<? extends Pair<T, I>> c) {
        return this.matrix.addAll(((PairSet)this.convert(c)).matrix);
    }

    public boolean addAll(Collection<T> trans, Collection<I> items) {
        if (trans == null || trans.isEmpty() || items == null || items.isEmpty()) {
            return false;
        }
        return this.matrix.addAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean addAll(T trans, Collection<I> items) {
        if (trans == null || items == null || items.isEmpty()) {
            return false;
        }
        return this.matrix.addAll(this.transactionToIndex(trans), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean addAll(Collection<T> trans, I item) {
        if (trans == null || trans.isEmpty() || item == null) {
            return false;
        }
        return this.matrix.addAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), this.itemToIndex(item));
    }

    @Override
    public void clear() {
        this.matrix.clear();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o instanceof Pair && this.contains(((Pair)o).transaction, ((Pair)o).item);
    }

    public boolean contains(T transaction, I item) {
        int t = this.transactionToIndex(transaction);
        if (t < 0) {
            return false;
        }
        int i = this.itemToIndex(item);
        if (i < 0) {
            return false;
        }
        return this.matrix.contains(t, i);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.matrix.containsAll(((PairSet)this.convert(c)).matrix);
    }

    public boolean containsAll(Collection<T> trans, Collection<I> items) {
        if (trans == null || trans.isEmpty() || items == null || items.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.matrix.containsAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean containsAll(T trans, Collection<I> items) {
        if (trans == null || items == null || items.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.matrix.containsAll(this.transactionToIndex(trans), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean containsAll(Collection<T> trans, I item) {
        if (trans == null || trans.isEmpty() || item == null) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.matrix.containsAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), this.itemToIndex(item));
    }

    @Override
    public boolean isEmpty() {
        return this.matrix.isEmpty();
    }

    @Override
    public ExtendedSet.ExtendedIterator<Pair<T, I>> iterator() {
        return new ExtendedSet.ExtendedIterator<Pair<T, I>>(){
            BinaryMatrix.CellIterator itr;
            {
                this.itr = PairSet.this.matrix.iterator();
            }

            @Override
            public Pair<T, I> next() {
                return PairSet.this.indexToPair(this.itr.next());
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public void skipAllBefore(Pair<T, I> element) {
                this.itr.skipAllBefore(PairSet.this.transactionToIndex(element.transaction), PairSet.this.itemToIndex(element.item));
            }
        };
    }

    @Override
    public ExtendedSet.ExtendedIterator<Pair<T, I>> descendingIterator() {
        return new ExtendedSet.ExtendedIterator<Pair<T, I>>(){
            BinaryMatrix.CellIterator itr;
            {
                this.itr = PairSet.this.matrix.descendingIterator();
            }

            @Override
            public Pair<T, I> next() {
                return PairSet.this.indexToPair(this.itr.next());
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public void skipAllBefore(Pair<T, I> element) {
                this.itr.skipAllBefore(PairSet.this.transactionToIndex(element.transaction), PairSet.this.itemToIndex(element.item));
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Pair && this.remove(((Pair)o).transaction, ((Pair)o).item);
    }

    public boolean remove(T transaction, I item) {
        return this.matrix.remove(this.transactionToIndex(transaction), this.itemToIndex(item));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.matrix.removeAll(((PairSet)this.convert(c)).matrix);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.matrix.retainAll(((PairSet)this.convert(c)).matrix);
    }

    public boolean removeAll(Collection<T> trans, Collection<I> items) {
        if (trans == null || trans.isEmpty() || items == null || items.isEmpty()) {
            return false;
        }
        return this.matrix.removeAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean removeAll(T trans, Collection<I> items) {
        if (trans == null || items == null || items.isEmpty()) {
            return false;
        }
        return this.matrix.removeAll(this.transactionToIndex(trans), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean removeAll(Collection<T> trans, I item) {
        if (trans == null || trans.isEmpty() || item == null) {
            return false;
        }
        return this.matrix.removeAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), this.itemToIndex(item));
    }

    public boolean retainAll(Collection<T> trans, Collection<I> items) {
        if (this.isEmpty()) {
            return false;
        }
        if (trans == null || trans.isEmpty() || items == null || items.isEmpty()) {
            this.clear();
            return true;
        }
        return this.matrix.retainAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean retainAll(T trans, Collection<I> items) {
        if (this.isEmpty()) {
            return false;
        }
        if (trans == null || items == null || items.isEmpty()) {
            this.clear();
            return true;
        }
        return this.matrix.retainAll(this.transactionToIndex(trans), ((IndexedSet)this.allItems.convert((Collection)items)).indices());
    }

    public boolean retainAll(Collection<T> trans, I item) {
        if (this.isEmpty()) {
            return false;
        }
        if (trans == null || trans.isEmpty() || item == null) {
            this.clear();
            return true;
        }
        return this.matrix.retainAll(((IndexedSet)this.allTransactions.convert((Collection)trans)).indices(), this.itemToIndex(item));
    }

    @Override
    public int size() {
        return this.matrix.size();
    }

    public IndexedSet<T> allTransactions() {
        return this.allTransactions;
    }

    public IndexedSet<I> allItems() {
        return this.allItems;
    }

    @Override
    public int hashCode() {
        return this.matrix.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PairSet)) {
            return false;
        }
        PairSet other = (PairSet)obj;
        return this.hasSameIndices(other) && this.matrix.equals(other.matrix);
    }

    public IndexedSet<I> itemsOf(T transaction) {
        ExtendedSet res = this.allItems.empty();
        ((IndexedSet)res).indices().addAll(this.matrix.getRow(this.transactionToIndex(transaction)));
        return res;
    }

    public IndexedSet<T> transactionsOf(I item) {
        ExtendedSet res = this.allTransactions.empty();
        ((IndexedSet)res).indices().addAll(this.matrix.getCol(this.itemToIndex(item)));
        return res;
    }

    public IndexedSet<T> involvedTransactions() {
        ExtendedSet res = this.allTransactions.empty();
        ((IndexedSet)res).indices().addAll(this.matrix.involvedRows());
        return res;
    }

    public IndexedSet<I> involvedItems() {
        ExtendedSet res = this.allItems.empty();
        ((IndexedSet)res).indices().addAll(this.matrix.involvedCols());
        return res;
    }

    @Override
    public Pair<T, I> get(int index) {
        return this.indexToPair(this.matrix.get(index));
    }

    @Override
    public int indexOf(Pair<T, I> element) {
        return this.matrix.indexOf(this.transactionToIndex(element.transaction), this.itemToIndex(element.item));
    }

    @Override
    public String debugInfo() {
        StringBuilder s = new StringBuilder();
        s.append("possible transactions: ");
        s.append(this.allTransactions);
        s.append('\n');
        s.append("possible items: ");
        s.append(this.allItems);
        s.append('\n');
        s.append("pairs:\n");
        s.append(this.matrix.toString());
        s.append("info: " + this.matrix.debugInfo());
        return s.toString();
    }

    @Override
    public double bitmapCompressionRatio() {
        return this.matrix.bitmapCompressionRatio();
    }

    @Override
    public double collectionCompressionRatio() {
        return this.matrix.collectionCompressionRatio();
    }

    public BinaryMatrix matrix() {
        return this.matrix;
    }

    public PairSet<T, I> empty() {
        return this.createFromIndices(this.matrix.empty());
    }

    @Override
    public void complement() {
        this.matrix.complement();
    }

    @Override
    public Comparator<? super Pair<T, I>> comparator() {
        return new Comparator<Pair<T, I>>(){

            @Override
            public int compare(Pair<T, I> o1, Pair<T, I> o2) {
                int r;
                int t2;
                int t1 = PairSet.this.transactionToIndex(o1.transaction);
                int n = t1 < (t2 = PairSet.this.transactionToIndex(o2.transaction)) ? -1 : (r = t1 == t2 ? 0 : 1);
                if (r == 0) {
                    int i2;
                    int i1 = PairSet.this.itemToIndex(o1.item);
                    r = i1 < (i2 = PairSet.this.itemToIndex(o2.item)) ? -1 : (i1 == i2 ? 0 : 1);
                }
                return r;
            }
        };
    }

    public PairSet<T, I> convert(Collection<?> c) {
        if (c == null) {
            return this.empty();
        }
        if (this.hasSameIndices(c)) {
            return (PairSet)c;
        }
        ExtendedSet res = this.empty();
        for (Pair p : c) {
            ((PairSet)res).matrix.add(this.transactionToIndex(p.transaction), this.itemToIndex(p.item));
        }
        return res;
    }

    public PairSet<T, I> convert(Object ... e) {
        return (PairSet)super.convert(e);
    }

    @Override
    public void clear(Pair<T, I> from, Pair<T, I> to) {
        this.matrix.clear(this.transactionToIndex(from.transaction), this.itemToIndex(from.item), this.transactionToIndex(to.transaction), this.itemToIndex(to.item));
    }

    @Override
    public int complementSize() {
        return this.matrix.complementSize();
    }

    public PairSet<T, I> complemented() {
        return this.createFromIndices(this.matrix.complemented());
    }

    public PairSet<T, I> difference(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.clone() : this.createFromIndices(this.matrix.difference(((PairSet)this.convert(other)).matrix));
    }

    @Override
    public boolean containsAny(Collection<? extends Pair<T, I>> other) {
        return other == null || this.matrix.containsAny(((PairSet)this.convert(other)).matrix);
    }

    @Override
    public boolean containsAtLeast(Collection<? extends Pair<T, I>> other, int minElements) {
        return other != null && !other.isEmpty() && this.matrix.containsAtLeast(((PairSet)this.convert(other)).matrix, minElements);
    }

    @Override
    public int differenceSize(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.size() : this.matrix.differenceSize(((PairSet)this.convert(other)).matrix);
    }

    @Override
    public void fill(Pair<T, I> from, Pair<T, I> to) {
        this.matrix.fill(this.transactionToIndex(from.transaction), this.itemToIndex(from.item), this.transactionToIndex(to.transaction), this.itemToIndex(to.item));
    }

    @Override
    public void flip(Pair<T, I> e) {
        this.matrix.flip(this.transactionToIndex(e.transaction), this.itemToIndex(e.item));
    }

    public PairSet<T, I> subSet(Pair<T, I> fromElement, Pair<T, I> toElement) {
        return (PairSet)super.subSet(fromElement, toElement);
    }

    public PairSet<T, I> headSet(Pair<T, I> toElement) {
        return (PairSet)super.headSet(toElement);
    }

    public PairSet<T, I> tailSet(Pair<T, I> fromElement) {
        return (PairSet)super.tailSet(fromElement);
    }

    public PairSet<T, I> intersection(Collection<? extends Pair<T, I>> c) {
        return c == null ? this.empty() : this.createFromIndices(this.matrix.intersection(((PairSet)this.convert(c)).matrix));
    }

    @Override
    public List<? extends PairSet<T, I>> powerSet() {
        return super.powerSet();
    }

    @Override
    public List<? extends PairSet<T, I>> powerSet(int min, int max) {
        return super.powerSet(min, max);
    }

    public PairSet<T, I> symmetricDifference(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.clone() : this.createFromIndices(this.matrix.symmetricDifference(((PairSet)this.convert(other)).matrix));
    }

    @Override
    public int symmetricDifferenceSize(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.size() : this.matrix.symmetricDifferenceSize(((PairSet)this.convert(other)).matrix);
    }

    public PairSet<T, I> union(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.clone() : this.createFromIndices(this.matrix.union(((PairSet)this.convert(other)).matrix));
    }

    @Override
    public int unionSize(Collection<? extends Pair<T, I>> other) {
        return other == null ? this.size() : this.matrix.unionSize(((PairSet)this.convert(other)).matrix);
    }

    @Override
    public Pair<T, I> first() {
        return this.indexToPair(this.matrix.first());
    }

    @Override
    public Pair<T, I> last() {
        return this.indexToPair(this.matrix.last());
    }

    @Override
    public int compareTo(ExtendedSet<Pair<T, I>> o) {
        return this.matrix.compareTo(((PairSet)this.convert(o)).matrix);
    }

    public PairSet<I, T> transposed() {
        return new PairSet<I, T>(this.matrix.transposed(), this.allItems, this.allTransactions);
    }

    public PairSet<T, I> merged(PairSet<T, I> other) {
        if (other == null) {
            return this.clone();
        }
        LinkedHashSet<T> newAllTransactions = new LinkedHashSet<T>(this.allTransactions);
        LinkedHashSet<I> newAllItems = new LinkedHashSet<I>(this.allItems);
        newAllTransactions.addAll(other.allTransactions);
        newAllItems.addAll(other.allItems);
        PairSet<T, I> res = new PairSet<T, I>(this.matrix.clone(), newAllTransactions, newAllItems);
        if (!other.isEmpty()) {
            res.addAll(other);
        }
        return res;
    }

    public PairSet<T, I> compacted() {
        if (this.isEmpty()) {
            return this.empty();
        }
        LinkedHashSet<T> newAllTransactions = new LinkedHashSet<T>(this.involvedTransactions());
        LinkedHashSet<I> newAllItems = new LinkedHashSet<I>(this.involvedItems());
        if (newAllTransactions.size() == this.allTransactions.size() && newAllItems.size() == this.allItems.size()) {
            return this.clone();
        }
        PairSet<T, I> res = new PairSet<T, I>(this.matrix.empty(), newAllTransactions, newAllItems);
        res.addAll(this);
        return res;
    }
}

