/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.api;

import com.google.gson.reflect.TypeToken;
import com.neotys.ascode.api.v2.client.ApiCallback;
import com.neotys.ascode.api.v2.client.ApiClient;
import com.neotys.ascode.api.v2.client.ApiException;
import com.neotys.ascode.api.v2.client.ApiResponse;
import com.neotys.ascode.api.v2.client.Configuration;
import com.neotys.ascode.api.v2.client.Pair;
import com.neotys.ascode.api.v2.client.ProgressRequestBody;
import com.neotys.ascode.api.v2.client.ProgressResponseBody;
import com.neotys.ascode.api.v2.client.model.ArrayOfElementDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfEventDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfSLAGlobalIndicatorDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfSLAPerIntervalDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfSLAPerTestDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfTestDefinition;
import com.neotys.ascode.api.v2.client.model.CounterDefinition;
import com.neotys.ascode.api.v2.client.model.CounterDefinitionArray;
import com.neotys.ascode.api.v2.client.model.CounterValues;
import com.neotys.ascode.api.v2.client.model.ElementDefinition;
import com.neotys.ascode.api.v2.client.model.ElementValues;
import com.neotys.ascode.api.v2.client.model.EventType;
import com.neotys.ascode.api.v2.client.model.InlineResponse200;
import com.neotys.ascode.api.v2.client.model.MonitorPostRequest;
import com.neotys.ascode.api.v2.client.model.Percentiles;
import com.neotys.ascode.api.v2.client.model.Points;
import com.neotys.ascode.api.v2.client.model.Sla;
import com.neotys.ascode.api.v2.client.model.TestDefinition;
import com.neotys.ascode.api.v2.client.model.TestRasterConfiguration;
import com.neotys.ascode.api.v2.client.model.TestRasterMultiConfiguration;
import com.neotys.ascode.api.v2.client.model.TestResultStopRequest;
import com.neotys.ascode.api.v2.client.model.TestStatistics;
import com.neotys.ascode.api.v2.client.model.TestUpdateRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ResultsApi {
    private ApiClient apiClient;

    public ResultsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResultsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTestResultCall(String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTestResultValidateBeforeCall(String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling deleteTestResult(Async)");
        }
        Call call = this.deleteTestResultCall(resultId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTestResult(String resultId) throws ApiException {
        this.deleteTestResultWithHttpInfo(resultId);
    }

    public ApiResponse<Void> deleteTestResultWithHttpInfo(String resultId) throws ApiException {
        Call call = this.deleteTestResultValidateBeforeCall(resultId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTestResultAsync(String resultId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTestResultValidateBeforeCall(resultId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTestCall(String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestValidateBeforeCall(String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTest(Async)");
        }
        Call call = this.getTestCall(resultId, progressListener, progressRequestListener);
        return call;
    }

    public TestDefinition getTest(String resultId) throws ApiException {
        ApiResponse<TestDefinition> resp = this.getTestWithHttpInfo(resultId);
        return resp.getData();
    }

    public ApiResponse<TestDefinition> getTestWithHttpInfo(String resultId) throws ApiException {
        Call call = this.getTestValidateBeforeCall(resultId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestAsync(String resultId, final ApiCallback<TestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestValidateBeforeCall(resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementDefinitionCall(String resultId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements/{elementId}".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementDefinitionValidateBeforeCall(String resultId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElementDefinition(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementDefinition(Async)");
        }
        Call call = this.getTestElementDefinitionCall(resultId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public ElementDefinition getTestElementDefinition(String resultId, String elementId) throws ApiException {
        ApiResponse<ElementDefinition> resp = this.getTestElementDefinitionWithHttpInfo(resultId, elementId);
        return resp.getData();
    }

    public ApiResponse<ElementDefinition> getTestElementDefinitionWithHttpInfo(String resultId, String elementId) throws ApiException {
        Call call = this.getTestElementDefinitionValidateBeforeCall(resultId, elementId, null, null);
        Type localVarReturnType = new TypeToken<ElementDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementDefinitionAsync(String resultId, String elementId, final ApiCallback<ElementDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementDefinitionValidateBeforeCall(resultId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ElementDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsCall(String resultId, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsValidateBeforeCall(String resultId, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElements(Async)");
        }
        if (category == null) {
            throw new ApiException("Missing the required parameter 'category' when calling getTestElements(Async)");
        }
        Call call = this.getTestElementsCall(resultId, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfElementDefinition getTestElements(String resultId, String category) throws ApiException {
        ApiResponse<ArrayOfElementDefinition> resp = this.getTestElementsWithHttpInfo(resultId, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfElementDefinition> getTestElementsWithHttpInfo(String resultId, String category) throws ApiException {
        Call call = this.getTestElementsValidateBeforeCall(resultId, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsAsync(String resultId, String category, final ApiCallback<ArrayOfElementDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsValidateBeforeCall(resultId, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsPercentilesCall(String resultId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements/{elementId}/percentiles".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsPercentilesValidateBeforeCall(String resultId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElementsPercentiles(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsPercentiles(Async)");
        }
        Call call = this.getTestElementsPercentilesCall(resultId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public Percentiles getTestElementsPercentiles(String resultId, String elementId) throws ApiException {
        ApiResponse<Percentiles> resp = this.getTestElementsPercentilesWithHttpInfo(resultId, elementId);
        return resp.getData();
    }

    public ApiResponse<Percentiles> getTestElementsPercentilesWithHttpInfo(String resultId, String elementId) throws ApiException {
        Call call = this.getTestElementsPercentilesValidateBeforeCall(resultId, elementId, null, null);
        Type localVarReturnType = new TypeToken<Percentiles>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsPercentilesAsync(String resultId, String elementId, final ApiCallback<Percentiles> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsPercentilesValidateBeforeCall(resultId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Percentiles>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsPointsCall(String resultId, String elementId, String statistics, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements/{elementId}/points".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (statistics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("statistics", statistics));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsPointsValidateBeforeCall(String resultId, String elementId, String statistics, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElementsPoints(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsPoints(Async)");
        }
        if (statistics == null) {
            throw new ApiException("Missing the required parameter 'statistics' when calling getTestElementsPoints(Async)");
        }
        Call call = this.getTestElementsPointsCall(resultId, elementId, statistics, progressListener, progressRequestListener);
        return call;
    }

    public Points getTestElementsPoints(String resultId, String elementId, String statistics) throws ApiException {
        ApiResponse<Points> resp = this.getTestElementsPointsWithHttpInfo(resultId, elementId, statistics);
        return resp.getData();
    }

    public ApiResponse<Points> getTestElementsPointsWithHttpInfo(String resultId, String elementId, String statistics) throws ApiException {
        Call call = this.getTestElementsPointsValidateBeforeCall(resultId, elementId, statistics, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsPointsAsync(String resultId, String elementId, String statistics, final ApiCallback<Points> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsPointsValidateBeforeCall(resultId, elementId, statistics, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsSlaCall(String resultId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements/{elementId}/sla".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsSlaValidateBeforeCall(String resultId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElementsSla(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsSla(Async)");
        }
        Call call = this.getTestElementsSlaCall(resultId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public Sla getTestElementsSla(String resultId, String elementId) throws ApiException {
        ApiResponse<Sla> resp = this.getTestElementsSlaWithHttpInfo(resultId, elementId);
        return resp.getData();
    }

    public ApiResponse<Sla> getTestElementsSlaWithHttpInfo(String resultId, String elementId) throws ApiException {
        Call call = this.getTestElementsSlaValidateBeforeCall(resultId, elementId, null, null);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsSlaAsync(String resultId, String elementId, final ApiCallback<Sla> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsSlaValidateBeforeCall(resultId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsValuesCall(String resultId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/elements/{elementId}/values".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsValuesValidateBeforeCall(String resultId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestElementsValues(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsValues(Async)");
        }
        Call call = this.getTestElementsValuesCall(resultId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public ElementValues getTestElementsValues(String resultId, String elementId) throws ApiException {
        ApiResponse<ElementValues> resp = this.getTestElementsValuesWithHttpInfo(resultId, elementId);
        return resp.getData();
    }

    public ApiResponse<ElementValues> getTestElementsValuesWithHttpInfo(String resultId, String elementId) throws ApiException {
        Call call = this.getTestElementsValuesValidateBeforeCall(resultId, elementId, null, null);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsValuesAsync(String resultId, String elementId, final ApiCallback<ElementValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsValuesValidateBeforeCall(resultId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestEventsCall(String resultId, List<EventType> types, Integer limit, Integer offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/events".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (types != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "types", types));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestEventsValidateBeforeCall(String resultId, List<EventType> types, Integer limit, Integer offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestEvents(Async)");
        }
        Call call = this.getTestEventsCall(resultId, types, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfEventDefinition getTestEvents(String resultId, List<EventType> types, Integer limit, Integer offset, String sort) throws ApiException {
        ApiResponse<ArrayOfEventDefinition> resp = this.getTestEventsWithHttpInfo(resultId, types, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<ArrayOfEventDefinition> getTestEventsWithHttpInfo(String resultId, List<EventType> types, Integer limit, Integer offset, String sort) throws ApiException {
        Call call = this.getTestEventsValidateBeforeCall(resultId, types, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfEventDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestEventsAsync(String resultId, List<EventType> types, Integer limit, Integer offset, String sort, final ApiCallback<ArrayOfEventDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestEventsValidateBeforeCall(resultId, types, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfEventDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestGraphCall(String resultId, TestRasterConfiguration body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestRasterConfiguration localVarPostBody = body;
        String localVarPath = "/test-results/{resultId}/graph".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"image/png", "image/jpeg", "image/tiff", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestGraphValidateBeforeCall(String resultId, TestRasterConfiguration body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestGraph(Async)");
        }
        Call call = this.getTestGraphCall(resultId, body, progressListener, progressRequestListener);
        return call;
    }

    public File getTestGraph(String resultId, TestRasterConfiguration body) throws ApiException {
        ApiResponse<File> resp = this.getTestGraphWithHttpInfo(resultId, body);
        return resp.getData();
    }

    public ApiResponse<File> getTestGraphWithHttpInfo(String resultId, TestRasterConfiguration body) throws ApiException {
        Call call = this.getTestGraphValidateBeforeCall(resultId, body, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestGraphAsync(String resultId, TestRasterConfiguration body, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestGraphValidateBeforeCall(resultId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorDefinitionCall(String resultId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/monitors/{counterId}".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorDefinitionValidateBeforeCall(String resultId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestMonitorDefinition(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorDefinition(Async)");
        }
        Call call = this.getTestMonitorDefinitionCall(resultId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public CounterDefinition getTestMonitorDefinition(String resultId, String counterId) throws ApiException {
        ApiResponse<CounterDefinition> resp = this.getTestMonitorDefinitionWithHttpInfo(resultId, counterId);
        return resp.getData();
    }

    public ApiResponse<CounterDefinition> getTestMonitorDefinitionWithHttpInfo(String resultId, String counterId) throws ApiException {
        Call call = this.getTestMonitorDefinitionValidateBeforeCall(resultId, counterId, null, null);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorDefinitionAsync(String resultId, String counterId, final ApiCallback<CounterDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorDefinitionValidateBeforeCall(resultId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsCall(String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/monitors".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsValidateBeforeCall(String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestMonitors(Async)");
        }
        Call call = this.getTestMonitorsCall(resultId, progressListener, progressRequestListener);
        return call;
    }

    public CounterDefinitionArray getTestMonitors(String resultId) throws ApiException {
        ApiResponse<CounterDefinitionArray> resp = this.getTestMonitorsWithHttpInfo(resultId);
        return resp.getData();
    }

    public ApiResponse<CounterDefinitionArray> getTestMonitorsWithHttpInfo(String resultId) throws ApiException {
        Call call = this.getTestMonitorsValidateBeforeCall(resultId, null, null);
        Type localVarReturnType = new TypeToken<CounterDefinitionArray>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsAsync(String resultId, final ApiCallback<CounterDefinitionArray> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsValidateBeforeCall(resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterDefinitionArray>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsPointsCall(String resultId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/monitors/{counterId}/points".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsPointsValidateBeforeCall(String resultId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestMonitorsPoints(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsPoints(Async)");
        }
        Call call = this.getTestMonitorsPointsCall(resultId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public Points getTestMonitorsPoints(String resultId, String counterId) throws ApiException {
        ApiResponse<Points> resp = this.getTestMonitorsPointsWithHttpInfo(resultId, counterId);
        return resp.getData();
    }

    public ApiResponse<Points> getTestMonitorsPointsWithHttpInfo(String resultId, String counterId) throws ApiException {
        Call call = this.getTestMonitorsPointsValidateBeforeCall(resultId, counterId, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsPointsAsync(String resultId, String counterId, final ApiCallback<Points> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsPointsValidateBeforeCall(resultId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsValuesCall(String resultId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/monitors/{counterId}/values".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsValuesValidateBeforeCall(String resultId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestMonitorsValues(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsValues(Async)");
        }
        Call call = this.getTestMonitorsValuesCall(resultId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public CounterValues getTestMonitorsValues(String resultId, String counterId) throws ApiException {
        ApiResponse<CounterValues> resp = this.getTestMonitorsValuesWithHttpInfo(resultId, counterId);
        return resp.getData();
    }

    public ApiResponse<CounterValues> getTestMonitorsValuesWithHttpInfo(String resultId, String counterId) throws ApiException {
        Call call = this.getTestMonitorsValuesValidateBeforeCall(resultId, counterId, null, null);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsValuesAsync(String resultId, String counterId, final ApiCallback<CounterValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsValuesValidateBeforeCall(resultId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMultiGraphCall(TestRasterMultiConfiguration body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestRasterMultiConfiguration localVarPostBody = body;
        String localVarPath = "/test-results/graph";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"image/png", "image/jpeg", "image/tiff", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMultiGraphValidateBeforeCall(TestRasterMultiConfiguration body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTestMultiGraphCall(body, progressListener, progressRequestListener);
        return call;
    }

    public File getTestMultiGraph(TestRasterMultiConfiguration body) throws ApiException {
        ApiResponse<File> resp = this.getTestMultiGraphWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<File> getTestMultiGraphWithHttpInfo(TestRasterMultiConfiguration body) throws ApiException {
        Call call = this.getTestMultiGraphValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMultiGraphAsync(TestRasterMultiConfiguration body, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMultiGraphValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAGlobalIndicatorsCall(String resultId, String status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/slas/statistics".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAGlobalIndicatorsValidateBeforeCall(String resultId, String status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestSLAGlobalIndicators(Async)");
        }
        Call call = this.getTestSLAGlobalIndicatorsCall(resultId, status, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAGlobalIndicatorDefinition getTestSLAGlobalIndicators(String resultId, String status) throws ApiException {
        ApiResponse<ArrayOfSLAGlobalIndicatorDefinition> resp = this.getTestSLAGlobalIndicatorsWithHttpInfo(resultId, status);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAGlobalIndicatorDefinition> getTestSLAGlobalIndicatorsWithHttpInfo(String resultId, String status) throws ApiException {
        Call call = this.getTestSLAGlobalIndicatorsValidateBeforeCall(resultId, status, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAGlobalIndicatorDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAGlobalIndicatorsAsync(String resultId, String status, final ApiCallback<ArrayOfSLAGlobalIndicatorDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAGlobalIndicatorsValidateBeforeCall(resultId, status, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAGlobalIndicatorDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAPerIntervalCall(String resultId, String status, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/slas/per-interval".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAPerIntervalValidateBeforeCall(String resultId, String status, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestSLAPerInterval(Async)");
        }
        Call call = this.getTestSLAPerIntervalCall(resultId, status, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAPerIntervalDefinition getTestSLAPerInterval(String resultId, String status, String category) throws ApiException {
        ApiResponse<ArrayOfSLAPerIntervalDefinition> resp = this.getTestSLAPerIntervalWithHttpInfo(resultId, status, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAPerIntervalDefinition> getTestSLAPerIntervalWithHttpInfo(String resultId, String status, String category) throws ApiException {
        Call call = this.getTestSLAPerIntervalValidateBeforeCall(resultId, status, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerIntervalDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAPerIntervalAsync(String resultId, String status, String category, final ApiCallback<ArrayOfSLAPerIntervalDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAPerIntervalValidateBeforeCall(resultId, status, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerIntervalDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAPerTestCall(String resultId, String status, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/slas/per-test".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAPerTestValidateBeforeCall(String resultId, String status, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestSLAPerTest(Async)");
        }
        Call call = this.getTestSLAPerTestCall(resultId, status, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAPerTestDefinition getTestSLAPerTest(String resultId, String status, String category) throws ApiException {
        ApiResponse<ArrayOfSLAPerTestDefinition> resp = this.getTestSLAPerTestWithHttpInfo(resultId, status, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAPerTestDefinition> getTestSLAPerTestWithHttpInfo(String resultId, String status, String category) throws ApiException {
        Call call = this.getTestSLAPerTestValidateBeforeCall(resultId, status, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAPerTestAsync(String resultId, String status, String category, final ApiCallback<ArrayOfSLAPerTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAPerTestValidateBeforeCall(resultId, status, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestStatisticsCall(String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results/{resultId}/statistics".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestStatisticsValidateBeforeCall(String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getTestStatistics(Async)");
        }
        Call call = this.getTestStatisticsCall(resultId, progressListener, progressRequestListener);
        return call;
    }

    public TestStatistics getTestStatistics(String resultId) throws ApiException {
        ApiResponse<TestStatistics> resp = this.getTestStatisticsWithHttpInfo(resultId);
        return resp.getData();
    }

    public ApiResponse<TestStatistics> getTestStatisticsWithHttpInfo(String resultId) throws ApiException {
        Call call = this.getTestStatisticsValidateBeforeCall(resultId, null, null);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestStatisticsAsync(String resultId, final ApiCallback<TestStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestStatisticsValidateBeforeCall(resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestsCall(String status, String project, String author, Integer limit, Integer offset, String sort, String fields, Boolean pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/test-results";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("project", project));
        }
        if (author != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("author", author));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fields", fields));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestsValidateBeforeCall(String status, String project, String author, Integer limit, Integer offset, String sort, String fields, Boolean pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTestsCall(status, project, author, limit, offset, sort, fields, pretty, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfTestDefinition getTests(String status, String project, String author, Integer limit, Integer offset, String sort, String fields, Boolean pretty) throws ApiException {
        ApiResponse<ArrayOfTestDefinition> resp = this.getTestsWithHttpInfo(status, project, author, limit, offset, sort, fields, pretty);
        return resp.getData();
    }

    public ApiResponse<ArrayOfTestDefinition> getTestsWithHttpInfo(String status, String project, String author, Integer limit, Integer offset, String sort, String fields, Boolean pretty) throws ApiException {
        Call call = this.getTestsValidateBeforeCall(status, project, author, limit, offset, sort, fields, pretty, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestsAsync(String status, String project, String author, Integer limit, Integer offset, String sort, String fields, Boolean pretty, final ApiCallback<ArrayOfTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestsValidateBeforeCall(status, project, author, limit, offset, sort, fields, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postTestMonitorsCall(MonitorPostRequest body, String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MonitorPostRequest localVarPostBody = body;
        String localVarPath = "/test-results/{resultId}/monitors".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTestMonitorsValidateBeforeCall(MonitorPostRequest body, String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postTestMonitors(Async)");
        }
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling postTestMonitors(Async)");
        }
        Call call = this.postTestMonitorsCall(body, resultId, progressListener, progressRequestListener);
        return call;
    }

    public void postTestMonitors(MonitorPostRequest body, String resultId) throws ApiException {
        this.postTestMonitorsWithHttpInfo(body, resultId);
    }

    public ApiResponse<Void> postTestMonitorsWithHttpInfo(MonitorPostRequest body, String resultId) throws ApiException {
        Call call = this.postTestMonitorsValidateBeforeCall(body, resultId, null, null);
        return this.apiClient.execute(call);
    }

    public Call postTestMonitorsAsync(MonitorPostRequest body, String resultId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTestMonitorsValidateBeforeCall(body, resultId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call stopTestResultCall(TestResultStopRequest body, String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestResultStopRequest localVarPostBody = body;
        String localVarPath = "/test-results/{resultId}/stop".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call stopTestResultValidateBeforeCall(TestResultStopRequest body, String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling stopTestResult(Async)");
        }
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling stopTestResult(Async)");
        }
        Call call = this.stopTestResultCall(body, resultId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse200 stopTestResult(TestResultStopRequest body, String resultId) throws ApiException {
        ApiResponse<InlineResponse200> resp = this.stopTestResultWithHttpInfo(body, resultId);
        return resp.getData();
    }

    public ApiResponse<InlineResponse200> stopTestResultWithHttpInfo(TestResultStopRequest body, String resultId) throws ApiException {
        Call call = this.stopTestResultValidateBeforeCall(body, resultId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call stopTestResultAsync(TestResultStopRequest body, String resultId, final ApiCallback<InlineResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.stopTestResultValidateBeforeCall(body, resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTestCall(TestUpdateRequest body, String resultId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestUpdateRequest localVarPostBody = body;
        String localVarPath = "/test-results/{resultId}".replaceAll("\\{resultId\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTestValidateBeforeCall(TestUpdateRequest body, String resultId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateTest(Async)");
        }
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling updateTest(Async)");
        }
        Call call = this.updateTestCall(body, resultId, progressListener, progressRequestListener);
        return call;
    }

    public TestDefinition updateTest(TestUpdateRequest body, String resultId) throws ApiException {
        ApiResponse<TestDefinition> resp = this.updateTestWithHttpInfo(body, resultId);
        return resp.getData();
    }

    public ApiResponse<TestDefinition> updateTestWithHttpInfo(TestUpdateRequest body, String resultId) throws ApiException {
        Call call = this.updateTestValidateBeforeCall(body, resultId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTestAsync(TestUpdateRequest body, String resultId, final ApiCallback<TestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTestValidateBeforeCall(body, resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

