/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ElementIdDefinition {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="statistics")
    private List<StatisticsEnum> statistics = null;

    public ElementIdDefinition id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="a6f2f595-7b62-4dc4-9368-a1cf670cd924", description="The id of the element. Can be a specific element identifier or one of the following keywords: - all-requests - all-pages - all-transactions")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ElementIdDefinition statistics(List<StatisticsEnum> statistics) {
        this.statistics = statistics;
        return this;
    }

    public ElementIdDefinition addStatisticsItem(StatisticsEnum statisticsItem) {
        if (this.statistics == null) {
            this.statistics = new ArrayList<StatisticsEnum>();
        }
        this.statistics.add(statisticsItem);
        return this;
    }

    @Schema(description="")
    public List<StatisticsEnum> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(List<StatisticsEnum> statistics) {
        this.statistics = statistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementIdDefinition elementIdDefinition = (ElementIdDefinition)o;
        return Objects.equals(this.id, elementIdDefinition.id) && Objects.equals(this.statistics, elementIdDefinition.statistics);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.statistics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ElementIdDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    statistics: ").append(this.toIndentedString(this.statistics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatisticsEnum {
        AVG_DURATION("AVG_DURATION"),
        MIN_DURATION("MIN_DURATION"),
        MAX_DURATION("MAX_DURATION"),
        COUNT("COUNT"),
        THROUGHPUT("THROUGHPUT"),
        ELEMENTS_PER_SECOND("ELEMENTS_PER_SECOND"),
        ERRORS("ERRORS"),
        ERRORS_PER_SECOND("ERRORS_PER_SECOND"),
        ERROR_RATE("ERROR_RATE"),
        AVG_TTFB("AVG_TTFB"),
        MIN_TTFB("MIN_TTFB"),
        MAX_TTFB("MAX_TTFB"),
        PERCENTILES_DURATION("PERCENTILES_DURATION");

        private String value;

        private StatisticsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatisticsEnum fromValue(String text) {
            for (StatisticsEnum b : StatisticsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatisticsEnum> {
            public void write(JsonWriter jsonWriter, StatisticsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatisticsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatisticsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

