/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class TestDefinition {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="author")
    private String author = null;
    @SerializedName(value="terminationReason")
    private TerminationReasonEnum terminationReason = null;
    @SerializedName(value="lgCount")
    private Integer lgCount = null;
    @SerializedName(value="project")
    private String project = null;
    @SerializedName(value="scenario")
    private String scenario = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="qualityStatus")
    private QualityStatusEnum qualityStatus = null;
    @SerializedName(value="startDate")
    private Long startDate = null;
    @SerializedName(value="endDate")
    private Long endDate = null;
    @SerializedName(value="duration")
    private Long duration = null;

    public TestDefinition id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the test result.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TestDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the test result.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the test result.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TestDefinition author(String author) {
        this.author = author;
        return this;
    }

    @Schema(description="First and Last name of the person who launched the test.")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public TestDefinition terminationReason(TerminationReasonEnum terminationReason) {
        this.terminationReason = terminationReason;
        return this;
    }

    @Schema(description="Reason that caused the test to end.")
    public TerminationReasonEnum getTerminationReason() {
        return this.terminationReason;
    }

    public void setTerminationReason(TerminationReasonEnum terminationReason) {
        this.terminationReason = terminationReason;
    }

    public TestDefinition lgCount(Integer lgCount) {
        this.lgCount = lgCount;
        return this;
    }

    @Schema(description="Total number of Load Generators used in the test result.")
    public Integer getLgCount() {
        return this.lgCount;
    }

    public void setLgCount(Integer lgCount) {
        this.lgCount = lgCount;
    }

    public TestDefinition project(String project) {
        this.project = project;
        return this;
    }

    @Schema(description="Name of the project.")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public TestDefinition scenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    @Schema(description="Name of the scenario.")
    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public TestDefinition status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the test result.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TestDefinition qualityStatus(QualityStatusEnum qualityStatus) {
        this.qualityStatus = qualityStatus;
        return this;
    }

    @Schema(description="Quality status of the test result.")
    public QualityStatusEnum getQualityStatus() {
        return this.qualityStatus;
    }

    public void setQualityStatus(QualityStatusEnum qualityStatus) {
        this.qualityStatus = qualityStatus;
    }

    public TestDefinition startDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Timestamp when the test started.")
    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public TestDefinition endDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(description="Timestamp when the test ended.")
    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public TestDefinition duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Schema(description="Test duration in seconds.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestDefinition testDefinition = (TestDefinition)o;
        return Objects.equals(this.id, testDefinition.id) && Objects.equals(this.name, testDefinition.name) && Objects.equals(this.description, testDefinition.description) && Objects.equals(this.author, testDefinition.author) && Objects.equals((Object)this.terminationReason, (Object)testDefinition.terminationReason) && Objects.equals(this.lgCount, testDefinition.lgCount) && Objects.equals(this.project, testDefinition.project) && Objects.equals(this.scenario, testDefinition.scenario) && Objects.equals((Object)this.status, (Object)testDefinition.status) && Objects.equals((Object)this.qualityStatus, (Object)testDefinition.qualityStatus) && Objects.equals(this.startDate, testDefinition.startDate) && Objects.equals(this.endDate, testDefinition.endDate) && Objects.equals(this.duration, testDefinition.duration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.author, this.terminationReason, this.lgCount, this.project, this.scenario, this.status, this.qualityStatus, this.startDate, this.endDate, this.duration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    terminationReason: ").append(this.toIndentedString((Object)this.terminationReason)).append("\n");
        sb.append("    lgCount: ").append(this.toIndentedString(this.lgCount)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    scenario: ").append(this.toIndentedString(this.scenario)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    qualityStatus: ").append(this.toIndentedString((Object)this.qualityStatus)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QualityStatusEnum {
        PASSED("PASSED"),
        FAILED("FAILED"),
        COMPUTING("COMPUTING"),
        UNKNOWN("UNKNOWN");

        private String value;

        private QualityStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QualityStatusEnum fromValue(String text) {
            for (QualityStatusEnum b : QualityStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<QualityStatusEnum> {
            public void write(JsonWriter jsonWriter, QualityStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QualityStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QualityStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        INIT("INIT"),
        STARTING("STARTING"),
        RUNNING("RUNNING"),
        TERMINATED("TERMINATED"),
        UNKNOWN("UNKNOWN");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TerminationReasonEnum {
        POLICY("POLICY"),
        VARIABLE("VARIABLE"),
        MANUAL("MANUAL"),
        LG_AVAILABILITY("LG_AVAILABILITY"),
        LICENSE("LICENSE"),
        UNKNOWN("UNKNOWN");

        private String value;

        private TerminationReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TerminationReasonEnum fromValue(String text) {
            for (TerminationReasonEnum b : TerminationReasonEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TerminationReasonEnum> {
            public void write(JsonWriter jsonWriter, TerminationReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TerminationReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TerminationReasonEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

