/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.neotys.ascode.api.v2.client.model.TestIdDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TestRasterMultiConfiguration {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="rasterType")
    private RasterTypeEnum rasterType = null;
    @SerializedName(value="xAxisLabel")
    private String xAxisLabel = null;
    @SerializedName(value="yAxisLabel")
    private String yAxisLabel = null;
    @SerializedName(value="legend")
    private Boolean legend = null;
    @SerializedName(value="multiYAxis")
    private Boolean multiYAxis = null;
    @SerializedName(value="theme")
    private ThemeEnum theme = null;
    @SerializedName(value="resultIds")
    private Map<String, TestIdDefinition> resultIds = null;

    public TestRasterMultiConfiguration width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(example="600", description="The width of the generated graph.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public TestRasterMultiConfiguration height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(example="200", description="The height of the generated graph.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public TestRasterMultiConfiguration title(String title) {
        this.title = title;
        return this;
    }

    @Schema(example="My Test", description="The main title of the generated graph.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TestRasterMultiConfiguration rasterType(RasterTypeEnum rasterType) {
        this.rasterType = rasterType;
        return this;
    }

    @Schema(example="PNG", description="The type of the generated graph. Can be PNG, TIFF or JPEG. Default is PNG.")
    public RasterTypeEnum getRasterType() {
        return this.rasterType;
    }

    public void setRasterType(RasterTypeEnum rasterType) {
        this.rasterType = rasterType;
    }

    public TestRasterMultiConfiguration xAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Schema(example="X Axis", description="The xAxis label of the generated graph.")
    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public TestRasterMultiConfiguration yAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Schema(example="Y Axis", description="The yAxis label of the generated graph.")
    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public TestRasterMultiConfiguration legend(Boolean legend) {
        this.legend = legend;
        return this;
    }

    @Schema(example="true", description="If true the legend is displayed. Default is true.")
    public Boolean isLegend() {
        return this.legend;
    }

    public void setLegend(Boolean legend) {
        this.legend = legend;
    }

    public TestRasterMultiConfiguration multiYAxis(Boolean multiYAxis) {
        this.multiYAxis = multiYAxis;
        return this;
    }

    @Schema(example="true", description="If true, display one axis per serie. Default is false.")
    public Boolean isMultiYAxis() {
        return this.multiYAxis;
    }

    public void setMultiYAxis(Boolean multiYAxis) {
        this.multiYAxis = multiYAxis;
    }

    public TestRasterMultiConfiguration theme(ThemeEnum theme) {
        this.theme = theme;
        return this;
    }

    @Schema(example="DARK", description="The theme of the graph. Default is TRANSPARENT.")
    public ThemeEnum getTheme() {
        return this.theme;
    }

    public void setTheme(ThemeEnum theme) {
        this.theme = theme;
    }

    public TestRasterMultiConfiguration resultIds(Map<String, TestIdDefinition> resultIds) {
        this.resultIds = resultIds;
        return this;
    }

    public TestRasterMultiConfiguration putResultIdsItem(String key, TestIdDefinition resultIdsItem) {
        if (this.resultIds == null) {
            this.resultIds = new HashMap<String, TestIdDefinition>();
        }
        this.resultIds.put(key, resultIdsItem);
        return this;
    }

    @Schema(example="{\"d30fdcc2-319e-4be5-818e-f1978907a3ce\":{\"elementIds\":[{\"id\":\"all-requests\",\"statistics\":[\"AVG_DURATION\"]},{\"id\":\"b8bfc48e-b7ed-48f8-b5ea-404d3faf15cb\",\"statistics\":[\"AVG_DURATION\",\"ELEMENTS_PER_SECOND\"]}]},\"dbe589d4-a10c-48d1-999e-da1fafa5df28\":{\"elementIds\":[{\"id\":\"all-requests\",\"statistics\":[\"AVG_DURATION\"]}],\"counterIds\":[\"a4bed45a-06b2-48e1-94fd-3ea979e4f360\",\"b5be82ff-3563-4812-93a5-4ea888e4e254\"]}}", description="")
    public Map<String, TestIdDefinition> getResultIds() {
        return this.resultIds;
    }

    public void setResultIds(Map<String, TestIdDefinition> resultIds) {
        this.resultIds = resultIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRasterMultiConfiguration testRasterMultiConfiguration = (TestRasterMultiConfiguration)o;
        return Objects.equals(this.width, testRasterMultiConfiguration.width) && Objects.equals(this.height, testRasterMultiConfiguration.height) && Objects.equals(this.title, testRasterMultiConfiguration.title) && Objects.equals((Object)this.rasterType, (Object)testRasterMultiConfiguration.rasterType) && Objects.equals(this.xAxisLabel, testRasterMultiConfiguration.xAxisLabel) && Objects.equals(this.yAxisLabel, testRasterMultiConfiguration.yAxisLabel) && Objects.equals(this.legend, testRasterMultiConfiguration.legend) && Objects.equals(this.multiYAxis, testRasterMultiConfiguration.multiYAxis) && Objects.equals((Object)this.theme, (Object)testRasterMultiConfiguration.theme) && Objects.equals(this.resultIds, testRasterMultiConfiguration.resultIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.title, this.rasterType, this.xAxisLabel, this.yAxisLabel, this.legend, this.multiYAxis, this.theme, this.resultIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestRasterMultiConfiguration {\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    rasterType: ").append(this.toIndentedString((Object)this.rasterType)).append("\n");
        sb.append("    xAxisLabel: ").append(this.toIndentedString(this.xAxisLabel)).append("\n");
        sb.append("    yAxisLabel: ").append(this.toIndentedString(this.yAxisLabel)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    multiYAxis: ").append(this.toIndentedString(this.multiYAxis)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString((Object)this.theme)).append("\n");
        sb.append("    resultIds: ").append(this.toIndentedString(this.resultIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThemeEnum {
        DARK("DARK"),
        LIGHT("LIGHT"),
        TRANSPARENT("TRANSPARENT");

        private String value;

        private ThemeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThemeEnum fromValue(String text) {
            for (ThemeEnum b : ThemeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ThemeEnum> {
            public void write(JsonWriter jsonWriter, ThemeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThemeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThemeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RasterTypeEnum {
        PNG("PNG"),
        TIFF("TIFF"),
        JPEG("JPEG");

        private String value;

        private RasterTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RasterTypeEnum fromValue(String text) {
            for (RasterTypeEnum b : RasterTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RasterTypeEnum> {
            public void write(JsonWriter jsonWriter, RasterTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RasterTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RasterTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

