/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TestSettingsCreated {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="userModifierName")
    private String userModifierName = null;
    @SerializedName(value="creationDate")
    private Long creationDate = null;
    @SerializedName(value="lastUpdateDate")
    private Long lastUpdateDate = null;
    @SerializedName(value="controllerZoneId")
    private String controllerZoneId = null;
    @SerializedName(value="lgZoneIds")
    private Map<String, Integer> lgZoneIds = null;
    @SerializedName(value="nextRunId")
    private BigDecimal nextRunId = null;
    @SerializedName(value="testResultNamingPattern")
    private String testResultNamingPattern = null;

    public TestSettingsCreated id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="5ed5350f-9f2f-4e2a-9acb-cdbcee874256", description="Unique identifier of the test.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TestSettingsCreated name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="New Test 1", description="Name of the test.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestSettingsCreated description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="My description", description="Description of the test.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TestSettingsCreated userModifierName(String userModifierName) {
        this.userModifierName = userModifierName;
        return this;
    }

    @Schema(description="Identifier of the user who modified the test settings.")
    public String getUserModifierName() {
        return this.userModifierName;
    }

    public void setUserModifierName(String userModifierName) {
        this.userModifierName = userModifierName;
    }

    public TestSettingsCreated creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(example="1582550441743", description="Timestamp when the test settings was created. Number of seconds since January 1, 1970.")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public TestSettingsCreated lastUpdateDate(Long lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Schema(example="1582550442163", description="Timestamp when the test settings was updated for the last time. Number of seconds since January 1, 1970.")
    public Long getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Long lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public TestSettingsCreated controllerZoneId(String controllerZoneId) {
        this.controllerZoneId = controllerZoneId;
        return this;
    }

    @Schema(example="defaultzone", description="The identifier of the controller.")
    public String getControllerZoneId() {
        return this.controllerZoneId;
    }

    public void setControllerZoneId(String controllerZoneId) {
        this.controllerZoneId = controllerZoneId;
    }

    public TestSettingsCreated lgZoneIds(Map<String, Integer> lgZoneIds) {
        this.lgZoneIds = lgZoneIds;
        return this;
    }

    public TestSettingsCreated putLgZoneIdsItem(String key, Integer lgZoneIdsItem) {
        if (this.lgZoneIds == null) {
            this.lgZoneIds = new HashMap<String, Integer>();
        }
        this.lgZoneIds.put(key, lgZoneIdsItem);
        return this;
    }

    @Schema(example="{\"defaultzone\":10,\"ZoneId\":5}", description="The LG zones with the number of the LGs.")
    public Map<String, Integer> getLgZoneIds() {
        return this.lgZoneIds;
    }

    public void setLgZoneIds(Map<String, Integer> lgZoneIds) {
        this.lgZoneIds = lgZoneIds;
    }

    public TestSettingsCreated nextRunId(BigDecimal nextRunId) {
        this.nextRunId = nextRunId;
        return this;
    }

    @Schema(description="The next run number. The value is incremented at each execution of the test.")
    public BigDecimal getNextRunId() {
        return this.nextRunId;
    }

    public void setNextRunId(BigDecimal nextRunId) {
        this.nextRunId = nextRunId;
    }

    public TestSettingsCreated testResultNamingPattern(String testResultNamingPattern) {
        this.testResultNamingPattern = testResultNamingPattern;
        return this;
    }

    @Schema(example="#${runID}", description="Pattern of the test results name.")
    public String getTestResultNamingPattern() {
        return this.testResultNamingPattern;
    }

    public void setTestResultNamingPattern(String testResultNamingPattern) {
        this.testResultNamingPattern = testResultNamingPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSettingsCreated testSettingsCreated = (TestSettingsCreated)o;
        return Objects.equals(this.id, testSettingsCreated.id) && Objects.equals(this.name, testSettingsCreated.name) && Objects.equals(this.description, testSettingsCreated.description) && Objects.equals(this.userModifierName, testSettingsCreated.userModifierName) && Objects.equals(this.creationDate, testSettingsCreated.creationDate) && Objects.equals(this.lastUpdateDate, testSettingsCreated.lastUpdateDate) && Objects.equals(this.controllerZoneId, testSettingsCreated.controllerZoneId) && Objects.equals(this.lgZoneIds, testSettingsCreated.lgZoneIds) && Objects.equals(this.nextRunId, testSettingsCreated.nextRunId) && Objects.equals(this.testResultNamingPattern, testSettingsCreated.testResultNamingPattern);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.userModifierName, this.creationDate, this.lastUpdateDate, this.controllerZoneId, this.lgZoneIds, this.nextRunId, this.testResultNamingPattern);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestSettingsCreated {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    userModifierName: ").append(this.toIndentedString(this.userModifierName)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    controllerZoneId: ").append(this.toIndentedString(this.controllerZoneId)).append("\n");
        sb.append("    lgZoneIds: ").append(this.toIndentedString(this.lgZoneIds)).append("\n");
        sb.append("    nextRunId: ").append(this.toIndentedString(this.nextRunId)).append("\n");
        sb.append("    testResultNamingPattern: ").append(this.toIndentedString(this.testResultNamingPattern)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

