/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.api;

import com.google.gson.reflect.TypeToken;
import com.neotys.ascode.api.v2.client.ApiCallback;
import com.neotys.ascode.api.v2.client.ApiClient;
import com.neotys.ascode.api.v2.client.ApiException;
import com.neotys.ascode.api.v2.client.ApiResponse;
import com.neotys.ascode.api.v2.client.Configuration;
import com.neotys.ascode.api.v2.client.Pair;
import com.neotys.ascode.api.v2.client.ProgressRequestBody;
import com.neotys.ascode.api.v2.client.ProgressResponseBody;
import com.neotys.ascode.api.v2.client.model.ProjectDefinition;
import com.neotys.ascode.api.v2.client.model.RunTestDefinition;
import com.neotys.ascode.api.v2.client.model.TestSettingsCreate;
import com.neotys.ascode.api.v2.client.model.TestSettingsCreated;
import com.neotys.ascode.api.v2.client.model.TestSettingsDefinition;
import com.neotys.ascode.api.v2.client.model.TestSettingsDefinitionList;
import com.neotys.ascode.api.v2.client.model.TestSettingsUpdate;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RuntimeApi {
    private ApiClient apiClient;

    public RuntimeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RuntimeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTestCall(String testId, String deleteResults, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (deleteResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("deleteResults", deleteResults));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTestValidateBeforeCall(String testId, String deleteResults, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling deleteTest(Async)");
        }
        Call call = this.deleteTestCall(testId, deleteResults, progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsDefinition deleteTest(String testId, String deleteResults) throws ApiException {
        ApiResponse<TestSettingsDefinition> resp = this.deleteTestWithHttpInfo(testId, deleteResults);
        return resp.getData();
    }

    public ApiResponse<TestSettingsDefinition> deleteTestWithHttpInfo(String testId, String deleteResults) throws ApiException {
        Call call = this.deleteTestValidateBeforeCall(testId, deleteResults, null, null);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTestAsync(String testId, String deleteResults, final ApiCallback<TestSettingsDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTestValidateBeforeCall(testId, deleteResults, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestListCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestListValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTestListCall(progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsDefinitionList getTestList() throws ApiException {
        ApiResponse<TestSettingsDefinitionList> resp = this.getTestListWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TestSettingsDefinitionList> getTestListWithHttpInfo() throws ApiException {
        Call call = this.getTestListValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TestSettingsDefinitionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestListAsync(final ApiCallback<TestSettingsDefinitionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestListValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsDefinitionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSettingsCall(String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSettingsValidateBeforeCall(String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestSettings(Async)");
        }
        Call call = this.getTestSettingsCall(testId, progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsDefinition getTestSettings(String testId) throws ApiException {
        ApiResponse<TestSettingsDefinition> resp = this.getTestSettingsWithHttpInfo(testId);
        return resp.getData();
    }

    public ApiResponse<TestSettingsDefinition> getTestSettingsWithHttpInfo(String testId) throws ApiException {
        Call call = this.getTestSettingsValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSettingsAsync(String testId, final ApiCallback<TestSettingsDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSettingsValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestsRunCall(String testId, String testResultName, String testResultDescription, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, Integer reservationCitrixVUs, Boolean publishTestResult, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/start".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (testResultName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("testResultName", testResultName));
        }
        if (testResultDescription != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("testResultDescription", testResultDescription));
        }
        if (asCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asCode", asCode));
        }
        if (reservationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationId", reservationId));
        }
        if (reservationDuration != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationDuration", reservationDuration));
        }
        if (reservationWebVUs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationWebVUs", reservationWebVUs));
        }
        if (reservationSAPVUs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationSAPVUs", reservationSAPVUs));
        }
        if (reservationCitrixVUs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationCitrixVUs", reservationCitrixVUs));
        }
        if (publishTestResult != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("publishTestResult", publishTestResult));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestsRunValidateBeforeCall(String testId, String testResultName, String testResultDescription, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, Integer reservationCitrixVUs, Boolean publishTestResult, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestsRun(Async)");
        }
        if (testResultName == null) {
            throw new ApiException("Missing the required parameter 'testResultName' when calling getTestsRun(Async)");
        }
        Call call = this.getTestsRunCall(testId, testResultName, testResultDescription, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, reservationCitrixVUs, publishTestResult, progressListener, progressRequestListener);
        return call;
    }

    public RunTestDefinition getTestsRun(String testId, String testResultName, String testResultDescription, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, Integer reservationCitrixVUs, Boolean publishTestResult) throws ApiException {
        ApiResponse<RunTestDefinition> resp = this.getTestsRunWithHttpInfo(testId, testResultName, testResultDescription, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, reservationCitrixVUs, publishTestResult);
        return resp.getData();
    }

    public ApiResponse<RunTestDefinition> getTestsRunWithHttpInfo(String testId, String testResultName, String testResultDescription, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, Integer reservationCitrixVUs, Boolean publishTestResult) throws ApiException {
        Call call = this.getTestsRunValidateBeforeCall(testId, testResultName, testResultDescription, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, reservationCitrixVUs, publishTestResult, null, null);
        Type localVarReturnType = new TypeToken<RunTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestsRunAsync(String testId, String testResultName, String testResultDescription, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, Integer reservationCitrixVUs, Boolean publishTestResult, final ApiCallback<RunTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestsRunValidateBeforeCall(testId, testResultName, testResultDescription, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, reservationCitrixVUs, publishTestResult, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchTestCall(String testId, TestSettingsUpdate body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestSettingsUpdate localVarPostBody = body;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchTestValidateBeforeCall(String testId, TestSettingsUpdate body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling patchTest(Async)");
        }
        Call call = this.patchTestCall(testId, body, progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsDefinition patchTest(String testId, TestSettingsUpdate body) throws ApiException {
        ApiResponse<TestSettingsDefinition> resp = this.patchTestWithHttpInfo(testId, body);
        return resp.getData();
    }

    public ApiResponse<TestSettingsDefinition> patchTestWithHttpInfo(String testId, TestSettingsUpdate body) throws ApiException {
        Call call = this.patchTestValidateBeforeCall(testId, body, null, null);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchTestAsync(String testId, TestSettingsUpdate body, final ApiCallback<TestSettingsDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchTestValidateBeforeCall(testId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCreateTestCall(TestSettingsCreate body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestSettingsCreate localVarPostBody = body;
        String localVarPath = "/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCreateTestValidateBeforeCall(TestSettingsCreate body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postCreateTest(Async)");
        }
        Call call = this.postCreateTestCall(body, progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsCreated postCreateTest(TestSettingsCreate body) throws ApiException {
        ApiResponse<TestSettingsCreated> resp = this.postCreateTestWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<TestSettingsCreated> postCreateTestWithHttpInfo(TestSettingsCreate body) throws ApiException {
        Call call = this.postCreateTestValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<TestSettingsCreated>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCreateTestAsync(TestSettingsCreate body, final ApiCallback<TestSettingsCreated> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCreateTestValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsCreated>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postUploadProjectCall(File file, String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/project".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postUploadProjectValidateBeforeCall(File file, String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling postUploadProject(Async)");
        }
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling postUploadProject(Async)");
        }
        Call call = this.postUploadProjectCall(file, testId, progressListener, progressRequestListener);
        return call;
    }

    public ProjectDefinition postUploadProject(File file, String testId) throws ApiException {
        ApiResponse<ProjectDefinition> resp = this.postUploadProjectWithHttpInfo(file, testId);
        return resp.getData();
    }

    public ApiResponse<ProjectDefinition> postUploadProjectWithHttpInfo(File file, String testId) throws ApiException {
        Call call = this.postUploadProjectValidateBeforeCall(file, testId, null, null);
        Type localVarReturnType = new TypeToken<ProjectDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postUploadProjectAsync(File file, String testId, final ApiCallback<ProjectDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postUploadProjectValidateBeforeCall(file, testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProjectDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call putTestCall(TestSettingsUpdate body, String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestSettingsUpdate localVarPostBody = body;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putTestValidateBeforeCall(TestSettingsUpdate body, String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling putTest(Async)");
        }
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling putTest(Async)");
        }
        Call call = this.putTestCall(body, testId, progressListener, progressRequestListener);
        return call;
    }

    public TestSettingsDefinition putTest(TestSettingsUpdate body, String testId) throws ApiException {
        ApiResponse<TestSettingsDefinition> resp = this.putTestWithHttpInfo(body, testId);
        return resp.getData();
    }

    public ApiResponse<TestSettingsDefinition> putTestWithHttpInfo(TestSettingsUpdate body, String testId) throws ApiException {
        Call call = this.putTestValidateBeforeCall(body, testId, null, null);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putTestAsync(TestSettingsUpdate body, String testId, final ApiCallback<TestSettingsDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putTestValidateBeforeCall(body, testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestSettingsDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

