/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="This object can represent a Controller or a Load Generator")
public class SimpleResourceApiDefinition {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public SimpleResourceApiDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="resource.domain.com:7100", description="Name of the controller or address of the load generator")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SimpleResourceApiDefinition version(String version) {
        this.version = version;
        return this;
    }

    @Schema(example="7.0.2", description="Version of the resource")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SimpleResourceApiDefinition status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the resource")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleResourceApiDefinition simpleResourceApiDefinition = (SimpleResourceApiDefinition)o;
        return Objects.equals(this.name, simpleResourceApiDefinition.name) && Objects.equals(this.version, simpleResourceApiDefinition.version) && Objects.equals((Object)this.status, (Object)simpleResourceApiDefinition.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleResourceApiDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        AVAILABLE("AVAILABLE"),
        RESERVED("RESERVED"),
        BUSY("BUSY");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

