/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.api;

import com.google.gson.reflect.TypeToken;
import com.neotys.ascode.api.v2.client.ApiCallback;
import com.neotys.ascode.api.v2.client.ApiClient;
import com.neotys.ascode.api.v2.client.ApiException;
import com.neotys.ascode.api.v2.client.ApiResponse;
import com.neotys.ascode.api.v2.client.Configuration;
import com.neotys.ascode.api.v2.client.Pair;
import com.neotys.ascode.api.v2.client.ProgressRequestBody;
import com.neotys.ascode.api.v2.client.ProgressResponseBody;
import com.neotys.ascode.api.v2.client.model.ArrayOfReservationDefinition;
import com.neotys.ascode.api.v2.client.model.ArrayOfZoneDefinition;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ResourcesApi {
    private ApiClient apiClient;

    public ResourcesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourcesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getReservationsCall(String fromDateTime, String toDateTime, Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources/reservations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fromDateTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromDateTime", fromDateTime));
        }
        if (toDateTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("toDateTime", toDateTime));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getReservationsValidateBeforeCall(String fromDateTime, String toDateTime, Integer limit, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getReservationsCall(fromDateTime, toDateTime, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfReservationDefinition getReservations(String fromDateTime, String toDateTime, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ArrayOfReservationDefinition> resp = this.getReservationsWithHttpInfo(fromDateTime, toDateTime, limit, offset);
        return resp.getData();
    }

    public ApiResponse<ArrayOfReservationDefinition> getReservationsWithHttpInfo(String fromDateTime, String toDateTime, Integer limit, Integer offset) throws ApiException {
        Call call = this.getReservationsValidateBeforeCall(fromDateTime, toDateTime, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfReservationDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getReservationsAsync(String fromDateTime, String toDateTime, Integer limit, Integer offset, final ApiCallback<ArrayOfReservationDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getReservationsValidateBeforeCall(fromDateTime, toDateTime, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfReservationDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getZonesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources/zones";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getZonesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getZonesCall(progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfZoneDefinition getZones() throws ApiException {
        ApiResponse<ArrayOfZoneDefinition> resp = this.getZonesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ArrayOfZoneDefinition> getZonesWithHttpInfo() throws ApiException {
        Call call = this.getZonesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ArrayOfZoneDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getZonesAsync(final ApiCallback<ArrayOfZoneDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getZonesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfZoneDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

