/*
 * Decompiled with CFR 0.152.
 */
package com.neotys.ascode.api.v2.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.neotys.ascode.api.v2.client.model.LgByZones;
import com.neotys.ascode.api.v2.client.model.ReservationOwner;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReservationDefinition {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="startDateTime")
    private BigDecimal startDateTime = null;
    @SerializedName(value="endDateTime")
    private BigDecimal endDateTime = null;
    @SerializedName(value="reservationWebVUs")
    private BigDecimal reservationWebVUs = null;
    @SerializedName(value="reservationSAPVUs")
    private BigDecimal reservationSAPVUs = null;
    @SerializedName(value="reservationCitrixVUs")
    private BigDecimal reservationCitrixVUs = null;
    @SerializedName(value="controllerZoneId")
    private String controllerZoneId = null;
    @SerializedName(value="neoloadVersion")
    private String neoloadVersion = null;
    @SerializedName(value="lgZonesResourcesReservation")
    private List<LgByZones> lgZonesResourcesReservation = null;
    @SerializedName(value="author")
    private String author = null;
    @SerializedName(value="owner")
    private ReservationOwner owner = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public ReservationDefinition id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="115c25af-f499-423f-a71e-63312601919e", description="Unique identifier of the reservation.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReservationDefinition status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the reservation.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ReservationDefinition startDateTime(BigDecimal startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(description="Timestamp when the reservation begins. Number of seconds since January 1, 1970.")
    public BigDecimal getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(BigDecimal startDateTime) {
        this.startDateTime = startDateTime;
    }

    public ReservationDefinition endDateTime(BigDecimal endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(description="Timestamp when the reservation ends. Number of seconds since January 1, 1970.")
    public BigDecimal getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(BigDecimal endDateTime) {
        this.endDateTime = endDateTime;
    }

    public ReservationDefinition reservationWebVUs(BigDecimal reservationWebVUs) {
        this.reservationWebVUs = reservationWebVUs;
        return this;
    }

    @Schema(description="The number of Web Virtual Users to be reserved.")
    public BigDecimal getReservationWebVUs() {
        return this.reservationWebVUs;
    }

    public void setReservationWebVUs(BigDecimal reservationWebVUs) {
        this.reservationWebVUs = reservationWebVUs;
    }

    public ReservationDefinition reservationSAPVUs(BigDecimal reservationSAPVUs) {
        this.reservationSAPVUs = reservationSAPVUs;
        return this;
    }

    @Schema(description="The number of SAP Virtual Users to be reserved.")
    public BigDecimal getReservationSAPVUs() {
        return this.reservationSAPVUs;
    }

    public void setReservationSAPVUs(BigDecimal reservationSAPVUs) {
        this.reservationSAPVUs = reservationSAPVUs;
    }

    public ReservationDefinition reservationCitrixVUs(BigDecimal reservationCitrixVUs) {
        this.reservationCitrixVUs = reservationCitrixVUs;
        return this;
    }

    @Schema(description="The number of Citrix Virtual Users to be reserved.")
    public BigDecimal getReservationCitrixVUs() {
        return this.reservationCitrixVUs;
    }

    public void setReservationCitrixVUs(BigDecimal reservationCitrixVUs) {
        this.reservationCitrixVUs = reservationCitrixVUs;
    }

    public ReservationDefinition controllerZoneId(String controllerZoneId) {
        this.controllerZoneId = controllerZoneId;
        return this;
    }

    @Schema(example="hIugt", description="Name of the zone.")
    public String getControllerZoneId() {
        return this.controllerZoneId;
    }

    public void setControllerZoneId(String controllerZoneId) {
        this.controllerZoneId = controllerZoneId;
    }

    public ReservationDefinition neoloadVersion(String neoloadVersion) {
        this.neoloadVersion = neoloadVersion;
        return this;
    }

    @Schema(example="7.0.2-20191110-1", description="Neoload version of the selected controller.")
    public String getNeoloadVersion() {
        return this.neoloadVersion;
    }

    public void setNeoloadVersion(String neoloadVersion) {
        this.neoloadVersion = neoloadVersion;
    }

    public ReservationDefinition lgZonesResourcesReservation(List<LgByZones> lgZonesResourcesReservation) {
        this.lgZonesResourcesReservation = lgZonesResourcesReservation;
        return this;
    }

    public ReservationDefinition addLgZonesResourcesReservationItem(LgByZones lgZonesResourcesReservationItem) {
        if (this.lgZonesResourcesReservation == null) {
            this.lgZonesResourcesReservation = new ArrayList<LgByZones>();
        }
        this.lgZonesResourcesReservation.add(lgZonesResourcesReservationItem);
        return this;
    }

    @Schema(description="")
    public List<LgByZones> getLgZonesResourcesReservation() {
        return this.lgZonesResourcesReservation;
    }

    public void setLgZonesResourcesReservation(List<LgByZones> lgZonesResourcesReservation) {
        this.lgZonesResourcesReservation = lgZonesResourcesReservation;
    }

    public ReservationDefinition author(String author) {
        this.author = author;
        return this;
    }

    @Schema(description="Name of the user who created the reservation.")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ReservationDefinition owner(ReservationOwner owner) {
        this.owner = owner;
        return this;
    }

    @Schema(description="")
    public ReservationOwner getOwner() {
        return this.owner;
    }

    public void setOwner(ReservationOwner owner) {
        this.owner = owner;
    }

    public ReservationDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Title of the reservation.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReservationDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the reservation.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReservationDefinition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(description="How the reservation has been created. By a user or automatically when a test started.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservationDefinition reservationDefinition = (ReservationDefinition)o;
        return Objects.equals(this.id, reservationDefinition.id) && Objects.equals((Object)this.status, (Object)reservationDefinition.status) && Objects.equals(this.startDateTime, reservationDefinition.startDateTime) && Objects.equals(this.endDateTime, reservationDefinition.endDateTime) && Objects.equals(this.reservationWebVUs, reservationDefinition.reservationWebVUs) && Objects.equals(this.reservationSAPVUs, reservationDefinition.reservationSAPVUs) && Objects.equals(this.reservationCitrixVUs, reservationDefinition.reservationCitrixVUs) && Objects.equals(this.controllerZoneId, reservationDefinition.controllerZoneId) && Objects.equals(this.neoloadVersion, reservationDefinition.neoloadVersion) && Objects.equals(this.lgZonesResourcesReservation, reservationDefinition.lgZonesResourcesReservation) && Objects.equals(this.author, reservationDefinition.author) && Objects.equals(this.owner, reservationDefinition.owner) && Objects.equals(this.name, reservationDefinition.name) && Objects.equals(this.description, reservationDefinition.description) && Objects.equals((Object)this.type, (Object)reservationDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.startDateTime, this.endDateTime, this.reservationWebVUs, this.reservationSAPVUs, this.reservationCitrixVUs, this.controllerZoneId, this.neoloadVersion, this.lgZonesResourcesReservation, this.author, this.owner, this.name, this.description, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReservationDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    reservationWebVUs: ").append(this.toIndentedString(this.reservationWebVUs)).append("\n");
        sb.append("    reservationSAPVUs: ").append(this.toIndentedString(this.reservationSAPVUs)).append("\n");
        sb.append("    reservationCitrixVUs: ").append(this.toIndentedString(this.reservationCitrixVUs)).append("\n");
        sb.append("    controllerZoneId: ").append(this.toIndentedString(this.controllerZoneId)).append("\n");
        sb.append("    neoloadVersion: ").append(this.toIndentedString(this.neoloadVersion)).append("\n");
        sb.append("    lgZonesResourcesReservation: ").append(this.toIndentedString(this.lgZonesResourcesReservation)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SCHEDULED("SCHEDULED"),
        AUTO_RESERVATION("AUTO_RESERVATION");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        WAITING("WAITING"),
        RUNNING("RUNNING"),
        PARTIALLY_RESERVED("PARTIALLY_RESERVED"),
        FAILED_TO_RESERVE("FAILED_TO_RESERVE"),
        RESERVED("RESERVED"),
        STOPPING("STOPPING"),
        ENDED("ENDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

