/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import java.util.concurrent.TimeUnit;

public final class AIMDLimit
extends AbstractLimit {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private final double backoffRatio;
    private final long timeout;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AIMDLimit(Builder builder) {
        super(builder.initialLimit);
        this.backoffRatio = builder.backoffRatio;
        this.timeout = builder.timeout;
    }

    @Override
    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        int currentLimit = this.getLimit();
        if (didDrop || rtt > this.timeout) {
            return Math.max(1, Math.min(currentLimit - 1, (int)((double)currentLimit * this.backoffRatio)));
        }
        if (inflight * 2 >= currentLimit) {
            return currentLimit + 1;
        }
        return currentLimit;
    }

    public String toString() {
        return "AIMDLimit [limit=" + this.getLimit() + "]";
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_TIMEOUT;
    }

    public static class Builder {
        private int initialLimit = 10;
        private double backoffRatio = 0.9;
        private long timeout = AIMDLimit.access$000();

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            Preconditions.checkArgument(backoffRatio < 1.0 && backoffRatio >= 0.5, "Backoff ratio must be in the range [0.5, 1.0)");
            this.backoffRatio = backoffRatio;
            return this;
        }

        public Builder timeout(long timeout, TimeUnit units) {
            Preconditions.checkArgument(timeout > 0L, "Timeout must be positive");
            this.timeout = units.toNanos(timeout);
            return this;
        }

        public AIMDLimit build() {
            return new AIMDLimit(this);
        }
    }
}

