/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.functions.Log10RootIntFunction;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
extends AbstractLimit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private static final IntUnaryOperator LOG10 = Log10RootIntFunction.create(0);
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private final int maxLimit;
    private final double smoothing;
    private final IntUnaryOperator alphaFunc;
    private final IntUnaryOperator betaFunc;
    private final IntUnaryOperator thresholdFunc;
    private final DoubleUnaryOperator increaseFunc;
    private final DoubleUnaryOperator decreaseFunc;
    private final MetricRegistry.SampleListener rttSampleListener;
    private final int probeMultiplier;
    private int probeCount = 0;
    private double probeJitter;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        super(builder.initialLimit);
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alphaFunc;
        this.betaFunc = builder.betaFunc;
        this.increaseFunc = builder.increaseFunc;
        this.decreaseFunc = builder.decreaseFunc;
        this.thresholdFunc = builder.thresholdFunc;
        this.smoothing = builder.smoothing;
        this.probeMultiplier = builder.probeMultiplier;
        this.resetProbeJitter();
        this.rttSampleListener = builder.registry.distribution("min_rtt", new String[0]);
    }

    private void resetProbeJitter() {
        this.probeJitter = ThreadLocalRandom.current().nextDouble(0.5, 1.0);
    }

    private boolean shouldProbe() {
        return this.probeJitter * (double)this.probeMultiplier * this.estimatedLimit <= (double)this.probeCount;
    }

    @Override
    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        if (rtt <= 0L) {
            throw new IllegalArgumentException("rtt must be >0 but got " + rtt);
        }
        ++this.probeCount;
        if (this.shouldProbe()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probe MinRTT {}", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            }
            this.resetProbeJitter();
            this.probeCount = 0;
            this.rtt_noload = rtt;
            return (int)this.estimatedLimit;
        }
        long rtt_noload = this.rtt_noload;
        if (rtt_noload == 0L || rtt < rtt_noload) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("New MinRTT {}", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            }
            this.rtt_noload = rtt;
            return (int)this.estimatedLimit;
        }
        this.rttSampleListener.addLongSample(rtt_noload);
        return this.updateEstimatedLimit(rtt, rtt_noload, inflight, didDrop);
    }

    private int updateEstimatedLimit(long rtt, long rtt_noload, int inflight, boolean didDrop) {
        double newLimit;
        double estimatedLimit = this.estimatedLimit;
        int queueSize = (int)Math.ceil(estimatedLimit * (1.0 - (double)rtt_noload / (double)rtt));
        if (didDrop) {
            newLimit = this.decreaseFunc.applyAsDouble(estimatedLimit);
        } else {
            if ((double)(inflight * 2) < estimatedLimit) {
                return (int)estimatedLimit;
            }
            int alpha = this.alphaFunc.applyAsInt((int)estimatedLimit);
            int beta = this.betaFunc.applyAsInt((int)estimatedLimit);
            int threshold = this.thresholdFunc.applyAsInt((int)estimatedLimit);
            if (queueSize <= threshold) {
                newLimit = estimatedLimit + (double)beta;
            } else if (queueSize < alpha) {
                newLimit = this.increaseFunc.applyAsDouble(estimatedLimit);
            } else if (queueSize > beta) {
                newLimit = this.decreaseFunc.applyAsDouble(estimatedLimit);
            } else {
                return (int)estimatedLimit;
            }
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        newLimit = (1.0 - this.smoothing) * estimatedLimit + this.smoothing * newLimit;
        if ((int)newLimit != (int)estimatedLimit && LOG.isDebugEnabled()) {
            LOG.debug("New limit={} minRtt={} ms winRtt={} ms queueSize={}", new Object[]{(int)newLimit, (double)TimeUnit.NANOSECONDS.toMicros(rtt_noload) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0, queueSize});
        }
        this.estimatedLimit = newLimit;
        return (int)newLimit;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.getLimit() + ", rtt_noload=" + (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double smoothing = 1.0;
        private IntUnaryOperator alphaFunc = limit -> 3 * LOG10.applyAsInt(limit);
        private IntUnaryOperator betaFunc = limit -> 6 * LOG10.applyAsInt(limit);
        private IntUnaryOperator thresholdFunc = VegasLimit.access$000();
        private DoubleUnaryOperator increaseFunc = limit -> limit + (double)LOG10.applyAsInt((int)limit);
        private DoubleUnaryOperator decreaseFunc = limit -> limit - (double)LOG10.applyAsInt((int)limit);
        private int probeMultiplier = 30;

        private Builder() {
        }

        public Builder probeMultiplier(int probeMultiplier) {
            this.probeMultiplier = probeMultiplier;
            return this;
        }

        public Builder alpha(int alpha) {
            this.alphaFunc = ignore -> alpha;
            return this;
        }

        @Deprecated
        public Builder threshold(Function<Integer, Integer> threshold) {
            this.thresholdFunc = threshold::apply;
            return this;
        }

        public Builder thresholdFunction(IntUnaryOperator threshold) {
            this.thresholdFunc = threshold;
            return this;
        }

        @Deprecated
        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alphaFunc = alpha::apply;
            return this;
        }

        public Builder alphaFunction(IntUnaryOperator alpha) {
            this.alphaFunc = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.betaFunc = ignore -> beta;
            return this;
        }

        @Deprecated
        public Builder beta(Function<Integer, Integer> beta) {
            this.betaFunc = beta::apply;
            return this;
        }

        public Builder betaFunction(IntUnaryOperator beta) {
            this.betaFunc = beta;
            return this;
        }

        @Deprecated
        public Builder increase(Function<Double, Double> increase) {
            this.increaseFunc = increase::apply;
            return this;
        }

        public Builder increaseFunction(DoubleUnaryOperator increase) {
            this.increaseFunc = increase;
            return this;
        }

        @Deprecated
        public Builder decrease(Function<Double, Double> decrease) {
            this.decreaseFunc = decrease::apply;
            return this;
        }

        public Builder decreaseFunction(DoubleUnaryOperator decrease) {
            this.decreaseFunc = decrease;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        @Deprecated
        public Builder tolerance(double tolerance) {
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Deprecated
        public Builder backoffRatio(double ratio) {
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            if (this.initialLimit > this.maxConcurrency) {
                LOG.warn("Initial limit {} exceeded maximum limit {}", (Object)this.initialLimit, (Object)this.maxConcurrency);
            }
            return new VegasLimit(this);
        }
    }
}

