/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.client;

import com.google.common.base.Preconditions;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.client.GrpcClientRequestContext;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ConcurrencyLimitClientInterceptor
implements ClientInterceptor {
    private static final Status LIMIT_EXCEEDED_STATUS = Status.UNAVAILABLE.withDescription("Concurrency limit reached");
    private final Limiter<GrpcClientRequestContext> grpcLimiter;

    public ConcurrencyLimitClientInterceptor(Limiter<GrpcClientRequestContext> grpcLimiter) {
        Preconditions.checkArgument((grpcLimiter != null ? 1 : 0) != 0, (Object)"GrpcLimiter cannot not be null");
        this.grpcLimiter = grpcLimiter;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
        final Optional listener = this.grpcLimiter.acquire((Object)new GrpcClientRequestContext(){

            @Override
            public MethodDescriptor<?, ?> getMethod() {
                return method;
            }

            @Override
            public CallOptions getCallOptions() {
                return callOptions;
            }
        });
        if (!listener.isPresent()) {
            return new ClientCall<ReqT, RespT>(){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    responseListener.onClose(LIMIT_EXCEEDED_STATUS, new Metadata());
                }

                public void request(int numMessages) {
                }

                public void cancel(String message, Throwable cause) {
                }

                public void halfClose() {
                }

                public void sendMessage(ReqT message) {
                }
            };
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            final AtomicBoolean done;
            {
                super(x0);
                this.done = new AtomicBoolean(false);
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            super.onClose(status, trailers);
                        }
                        finally {
                            listener.ifPresent(l -> {
                                if (done.compareAndSet(false, true)) {
                                    if (status.isOk()) {
                                        l.onSuccess();
                                    } else if (Status.Code.UNAVAILABLE == status.getCode()) {
                                        l.onDropped();
                                    } else {
                                        l.onIgnore();
                                    }
                                }
                            });
                        }
                    }
                }, headers);
            }

            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                try {
                    super.cancel(message, cause);
                }
                finally {
                    if (this.done.compareAndSet(false, true)) {
                        listener.ifPresent(Limiter.Listener::onIgnore);
                    }
                }
            }
        };
    }
}

