/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.client;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.client.GrpcClientRequestContext;
import com.netflix.concurrency.limits.limiter.AbstractLimiterBuilder;
import com.netflix.concurrency.limits.limiter.BlockingLimiter;
import com.netflix.concurrency.limits.strategy.LookupPartitionStrategy;
import io.grpc.CallOptions;
import java.util.function.Consumer;

public final class GrpcClientLimiterBuilder
extends AbstractLimiterBuilder<GrpcClientLimiterBuilder, GrpcClientRequestContext> {
    private boolean blockOnLimit = false;

    public GrpcClientLimiterBuilder partitionByMethod(Consumer<LookupPartitionStrategy.Builder<GrpcClientRequestContext>> configurer) {
        return (GrpcClientLimiterBuilder)this.partitionByLookup(context -> context.getMethod().getFullMethodName(), configurer);
    }

    public GrpcClientLimiterBuilder partitionByCallOption(CallOptions.Key<String> option, Consumer<LookupPartitionStrategy.Builder<GrpcClientRequestContext>> configurer) {
        return (GrpcClientLimiterBuilder)this.partitionByLookup(context -> (String)context.getCallOptions().getOption(option), configurer);
    }

    public <T> GrpcClientLimiterBuilder blockOnLimit(boolean blockOnLimit) {
        this.blockOnLimit = blockOnLimit;
        return this;
    }

    protected GrpcClientLimiterBuilder self() {
        return this;
    }

    public Limiter<GrpcClientRequestContext> build() {
        Limiter limiter = this.buildLimiter();
        if (this.blockOnLimit) {
            limiter = BlockingLimiter.wrap((Limiter)limiter);
        }
        return limiter;
    }
}

