/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.server;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.server.GrpcServerRequestContext;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConcurrencyLimitServerInterceptor
implements ServerInterceptor {
    private static final Status LIMIT_EXCEEDED_STATUS = Status.UNAVAILABLE.withDescription("Concurrency limit reached");
    private final Limiter<GrpcServerRequestContext> grpcLimiter;

    public ConcurrencyLimitServerInterceptor(Limiter<GrpcServerRequestContext> grpcLimiter) {
        this.grpcLimiter = grpcLimiter;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final Optional listener = this.grpcLimiter.acquire((Object)new GrpcServerRequestContext(){

            @Override
            public ServerCall<?, ?> getCall() {
                return call;
            }

            @Override
            public Metadata getHeaders() {
                return headers;
            }
        });
        if (!listener.isPresent()) {
            call.close(LIMIT_EXCEEDED_STATUS, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        final AtomicBoolean done = new AtomicBoolean(false);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void close(Status status, Metadata trailers) {
                try {
                    super.close(status, trailers);
                }
                finally {
                    if (done.compareAndSet(false, true)) {
                        if (status.isOk()) {
                            ((Limiter.Listener)listener.get()).onSuccess();
                        } else {
                            ((Limiter.Listener)listener.get()).onIgnore();
                        }
                    }
                }
            }
        }, headers)){

            public void onCancel() {
                try {
                    super.onCancel();
                }
                finally {
                    if (done.compareAndSet(false, true)) {
                        ((Limiter.Listener)listener.get()).onIgnore();
                    }
                }
            }
        };
    }
}

