/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.client;

import com.google.common.base.Preconditions;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.client.GrpcClientRequestContext;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ConcurrencyLimitClientInterceptor
implements ClientInterceptor {
    private static final Status LIMIT_EXCEEDED_STATUS = Status.UNAVAILABLE.withDescription("Client concurrency limit reached");
    private final Limiter<GrpcClientRequestContext> grpcLimiter;

    public ConcurrencyLimitClientInterceptor(Limiter<GrpcClientRequestContext> grpcLimiter) {
        Preconditions.checkArgument((grpcLimiter != null ? 1 : 0) != 0, (Object)"GrpcLimiter cannot not be null");
        this.grpcLimiter = grpcLimiter;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
        if (!method.getType().serverSendsOneMessage() || !method.getType().clientSendsOneMessage()) {
            return next.newCall(method, callOptions);
        }
        return this.grpcLimiter.acquire((Object)new GrpcClientRequestContext(){

            @Override
            public MethodDescriptor<?, ?> getMethod() {
                return method;
            }

            @Override
            public CallOptions getCallOptions() {
                return callOptions;
            }
        }).map(listener -> new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions), (Limiter.Listener)listener){
            final AtomicBoolean done;
            final /* synthetic */ Limiter.Listener val$listener;
            {
                this.val$listener = listener;
                super(x0);
                this.done = new AtomicBoolean(false);
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            super.onClose(status, trailers);
                        }
                        finally {
                            if (done.compareAndSet(false, true)) {
                                if (status.isOk()) {
                                    val$listener.onSuccess();
                                } else if (Status.Code.UNAVAILABLE == status.getCode()) {
                                    val$listener.onDropped();
                                } else {
                                    val$listener.onIgnore();
                                }
                            }
                        }
                    }
                }, headers);
            }

            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                try {
                    super.cancel(message, cause);
                }
                finally {
                    if (this.done.compareAndSet(false, true)) {
                        this.val$listener.onIgnore();
                    }
                }
            }
        }).orElseGet(() -> new ClientCall<ReqT, RespT>(){
            private ClientCall.Listener responseListener;

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                this.responseListener = responseListener;
            }

            public void request(int numMessages) {
            }

            public void cancel(String message, Throwable cause) {
            }

            public void halfClose() {
                this.responseListener.onClose(LIMIT_EXCEEDED_STATUS, new Metadata());
            }

            public void sendMessage(ReqT message) {
            }
        });
    }
}

