/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.spectator;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.function.Supplier;

public final class SpectatorMetricRegistry
implements MetricRegistry {
    private final Registry registry;
    private final Id baseId;

    public SpectatorMetricRegistry(Registry registry, Id baseId) {
        this.registry = registry;
        this.baseId = baseId;
    }

    public MetricRegistry.SampleListener registerDistribution(String id, String ... tagNameValuePairs) {
        DistributionSummary summary = this.registry.distributionSummary(this.suffixBaseId(id).withTags(tagNameValuePairs));
        return value -> summary.record(value.longValue());
    }

    public void registerGauge(String id, Supplier<Number> supplier, String ... tagNameValuePairs) {
        Id metricId = this.suffixBaseId(id).withTags(tagNameValuePairs);
        PolledMeter.remove((Registry)this.registry, (Id)metricId);
        ((PolledMeter.Builder)PolledMeter.using((Registry)this.registry).withId(metricId)).monitorValue(supplier, ignore -> ((Number)supplier.get()).doubleValue());
    }

    private Id suffixBaseId(String suffix) {
        return this.registry.createId(this.baseId.name() + "." + suffix).withTags(this.baseId.tags());
    }
}

