/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInfoManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInfoManager.class);
    private static final ApplicationInfoManager instance = new ApplicationInfoManager();
    private InstanceInfo instanceInfo;
    private EurekaInstanceConfig config;

    private ApplicationInfoManager() {
    }

    public static ApplicationInfoManager getInstance() {
        return instance;
    }

    public void initComponent(EurekaInstanceConfig config) {
        try {
            this.config = config;
            LeaseInfo.Builder leaseInfoBuilder = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(config.getLeaseRenewalIntervalInSeconds()).setDurationInSecs(config.getLeaseExpirationDurationInSeconds());
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
            builder.setNamespace(config.getNamespace()).setAppName(config.getAppname()).setDataCenterInfo(config.getDataCenterInfo()).setIPAddr(config.getIpAddress()).setHostName(config.getHostName(false)).setPort(config.getNonSecurePort()).enablePort(InstanceInfo.PortType.UNSECURE, config.isNonSecurePortEnabled()).setSecurePort(config.getSecurePort()).enablePort(InstanceInfo.PortType.SECURE, config.getSecurePortEnabled()).setVIPAddress(config.getVirtualHostName()).setSecureVIPAddress(config.getSecureVirtualHostName()).setHomePageUrl(config.getHomePageUrlPath(), config.getHomePageUrl()).setStatusPageUrl(config.getStatusPageUrlPath(), config.getStatusPageUrl()).setHealthCheckUrls(config.getHealthCheckUrlPath(), config.getHealthCheckUrl(), config.getSecureHealthCheckUrl()).setASGName(config.getASGName());
            if (!config.isInstanceEnabledOnit()) {
                builder.setStatus(InstanceInfo.InstanceStatus.STARTING);
            }
            for (Map.Entry<String, String> mapEntry : config.getMetadataMap().entrySet()) {
                String key = mapEntry.getKey();
                String value = mapEntry.getValue();
                builder.add(key, value);
            }
            this.instanceInfo = builder.build();
            this.instanceInfo.setLeaseInfo(leaseInfoBuilder.build());
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize ApplicationInfoManager", e);
        }
    }

    public InstanceInfo getInfo() {
        return this.instanceInfo;
    }

    public void registerAppMetadata(Map<String, String> appMetadata) {
        this.instanceInfo.registerRuntimeMetadata(appMetadata);
    }

    public void setInstanceStatus(InstanceInfo.InstanceStatus status) {
        this.instanceInfo.setStatus(status);
    }

    public void refreshDataCenterInfoIfRequired() {
        String existingHostname = this.instanceInfo.getHostName();
        String newHostname = this.config.getHostName(true);
        if (newHostname != null && !newHostname.equals(existingHostname)) {
            logger.warn("The public hostname changed from : " + existingHostname + " => " + newHostname);
            InstanceInfo.Builder builder = new InstanceInfo.Builder(this.instanceInfo);
            builder.setHostName(newHostname).setDataCenterInfo(this.config.getDataCenterInfo());
            this.instanceInfo.setIsDirty(true);
        }
    }
}

