/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo.providers;

import com.google.inject.Provider;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaConfigBasedInstanceInfoProvider
implements Provider<InstanceInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(EurekaConfigBasedInstanceInfoProvider.class);
    private final EurekaInstanceConfig config;
    private InstanceInfo instanceInfo;

    @Inject
    public EurekaConfigBasedInstanceInfoProvider(EurekaInstanceConfig config) {
        this.config = config;
    }

    public synchronized InstanceInfo get() {
        if (this.instanceInfo == null) {
            LeaseInfo.Builder leaseInfoBuilder = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(this.config.getLeaseRenewalIntervalInSeconds()).setDurationInSecs(this.config.getLeaseExpirationDurationInSeconds());
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
            builder.setNamespace(this.config.getNamespace()).setAppName(this.config.getAppname()).setAppGroupName(this.config.getAppGroupName()).setDataCenterInfo(this.config.getDataCenterInfo()).setIPAddr(this.config.getIpAddress()).setHostName(this.config.getHostName(false)).setPort(this.config.getNonSecurePort()).enablePort(InstanceInfo.PortType.UNSECURE, this.config.isNonSecurePortEnabled()).setSecurePort(this.config.getSecurePort()).enablePort(InstanceInfo.PortType.SECURE, this.config.getSecurePortEnabled()).setVIPAddress(this.config.getVirtualHostName()).setSecureVIPAddress(this.config.getSecureVirtualHostName()).setHomePageUrl(this.config.getHomePageUrlPath(), this.config.getHomePageUrl()).setStatusPageUrl(this.config.getStatusPageUrlPath(), this.config.getStatusPageUrl()).setHealthCheckUrls(this.config.getHealthCheckUrlPath(), this.config.getHealthCheckUrl(), this.config.getSecureHealthCheckUrl()).setASGName(this.config.getASGName());
            if (!this.config.isInstanceEnabledOnit()) {
                InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.STARTING;
                LOG.info("Setting initial instance status as: " + (Object)((Object)initialStatus));
                builder.setStatus(initialStatus);
            } else {
                LOG.info("Setting initial instance status as: " + (Object)((Object)InstanceInfo.InstanceStatus.UP) + ". This may be too early for the instance to advertise itself as available. " + "You would instead want to control this via a healthcheck handler.");
            }
            for (Map.Entry<String, String> mapEntry : this.config.getMetadataMap().entrySet()) {
                String key = mapEntry.getKey();
                String value = mapEntry.getValue();
                builder.add(key, value);
            }
            this.instanceInfo = builder.build();
            this.instanceInfo.setLeaseInfo(leaseInfoBuilder.build());
        }
        return this.instanceInfo;
    }
}

