/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaClientFactoryBuilder;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.ApacheHttpClientConnectionCleaner;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.discovery.shared.transport.jersey.JerseyApplicationClient;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public class JerseyEurekaHttpClientFactory
implements TransportClientFactory {
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private final EurekaJerseyClient jerseyClient;
    private final ApacheHttpClient4 apacheClient;
    private final ApacheHttpClientConnectionCleaner cleaner;
    private final Map<String, String> additionalHeaders;

    @Deprecated
    public JerseyEurekaHttpClientFactory(EurekaJerseyClient jerseyClient, boolean allowRedirects) {
        this(jerseyClient, null, -1L, Collections.singletonMap(HTTP_X_DISCOVERY_ALLOW_REDIRECT, allowRedirects ? "true" : "false"));
    }

    @Deprecated
    public JerseyEurekaHttpClientFactory(EurekaJerseyClient jerseyClient, Map<String, String> additionalHeaders) {
        this(jerseyClient, null, -1L, additionalHeaders);
    }

    public JerseyEurekaHttpClientFactory(ApacheHttpClient4 apacheClient, long connectionIdleTimeout, Map<String, String> additionalHeaders) {
        this(null, apacheClient, connectionIdleTimeout, additionalHeaders);
    }

    private JerseyEurekaHttpClientFactory(EurekaJerseyClient jerseyClient, ApacheHttpClient4 apacheClient, long connectionIdleTimeout, Map<String, String> additionalHeaders) {
        this.jerseyClient = jerseyClient;
        this.apacheClient = jerseyClient != null ? jerseyClient.getClient() : apacheClient;
        this.additionalHeaders = additionalHeaders;
        this.cleaner = new ApacheHttpClientConnectionCleaner(this.apacheClient, connectionIdleTimeout);
    }

    @Override
    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new JerseyApplicationClient((Client)this.apacheClient, endpoint.getServiceUrl(), this.additionalHeaders);
    }

    @Override
    public void shutdown() {
        this.cleaner.shutdown();
        if (this.jerseyClient != null) {
            this.jerseyClient.destroyResources();
        } else {
            this.apacheClient.destroy();
        }
    }

    public static JerseyEurekaHttpClientFactory create(EurekaClientConfig clientConfig, Collection<ClientFilter> additionalFilters, InstanceInfo myInstanceInfo, AbstractEurekaIdentity clientIdentity) {
        JerseyEurekaHttpClientFactoryBuilder clientBuilder = (JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)JerseyEurekaHttpClientFactory.newBuilder().withAdditionalFilters(additionalFilters).withMyInstanceInfo(myInstanceInfo)).withUserAgent("Java-EurekaClient")).withClientAccept(EurekaAccept.fromString(clientConfig.getClientDataAccept()))).withAllowRedirect(clientConfig.allowRedirects())).withConnectionTimeout(clientConfig.getEurekaServerConnectTimeoutSeconds() * 1000)).withReadTimeout(clientConfig.getEurekaServerReadTimeoutSeconds() * 1000)).withMaxConnectionsPerHost(clientConfig.getEurekaServerTotalConnectionsPerHost())).withMaxTotalConnections(clientConfig.getEurekaServerTotalConnections())).withConnectionIdleTimeout(clientConfig.getEurekaConnectionIdleTimeoutSeconds() * 1000)).withEncoder(clientConfig.getEncoderName())).withDecoder(clientConfig.getDecoderName(), clientConfig.getClientDataAccept())).withClientIdentity(clientIdentity);
        if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            ((JerseyEurekaHttpClientFactoryBuilder)clientBuilder.withClientName("DiscoveryClient-HTTPClient-System")).withSystemSSLConfiguration();
        } else if (clientConfig.getProxyHost() != null && clientConfig.getProxyPort() != null) {
            ((JerseyEurekaHttpClientFactoryBuilder)clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient")).withProxy(clientConfig.getProxyHost(), Integer.parseInt(clientConfig.getProxyPort()), clientConfig.getProxyUserName(), clientConfig.getProxyPassword());
        } else {
            clientBuilder.withClientName("DiscoveryClient-HTTPClient");
        }
        return clientBuilder.build();
    }

    public static JerseyEurekaHttpClientFactoryBuilder newBuilder() {
        return new JerseyEurekaHttpClientFactoryBuilder().withExperimental(false);
    }

    public static JerseyEurekaHttpClientFactoryBuilder experimentalBuilder() {
        return new JerseyEurekaHttpClientFactoryBuilder().withExperimental(true);
    }

    public static class JerseyEurekaHttpClientFactoryBuilder
    extends EurekaClientFactoryBuilder<JerseyEurekaHttpClientFactory, JerseyEurekaHttpClientFactoryBuilder> {
        private Collection<ClientFilter> additionalFilters = Collections.emptyList();
        private boolean experimental = false;

        public JerseyEurekaHttpClientFactoryBuilder withAdditionalFilters(Collection<ClientFilter> additionalFilters) {
            this.additionalFilters = additionalFilters;
            return this;
        }

        public JerseyEurekaHttpClientFactoryBuilder withExperimental(boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        @Override
        public JerseyEurekaHttpClientFactory build() {
            HashMap<String, String> additionalHeaders = new HashMap<String, String>();
            if (this.allowRedirect) {
                additionalHeaders.put(JerseyEurekaHttpClientFactory.HTTP_X_DISCOVERY_ALLOW_REDIRECT, "true");
            }
            if (EurekaAccept.compact == this.eurekaAccept) {
                additionalHeaders.put("X-Eureka-Accept", this.eurekaAccept.name());
            }
            if (this.experimental) {
                return this.buildExperimental(additionalHeaders);
            }
            return this.buildLegacy(additionalHeaders, this.systemSSL);
        }

        private JerseyEurekaHttpClientFactory buildLegacy(Map<String, String> additionalHeaders, boolean systemSSL) {
            EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder().withClientName(this.clientName).withUserAgent("Java-EurekaClient").withConnectionTimeout(this.connectionTimeout).withReadTimeout(this.readTimeout).withMaxConnectionsPerHost(this.maxConnectionsPerHost).withMaxTotalConnections(this.maxTotalConnections).withConnectionIdleTimeout((int)this.connectionIdleTimeout).withEncoderWrapper(this.encoderWrapper).withDecoderWrapper(this.decoderWrapper);
            if (systemSSL) {
                clientBuilder.withSystemSSLConfiguration();
            }
            EurekaJerseyClient jerseyClient = clientBuilder.build();
            ApacheHttpClient4 discoveryApacheClient = jerseyClient.getClient();
            this.addFilters(discoveryApacheClient);
            return new JerseyEurekaHttpClientFactory(jerseyClient, additionalHeaders);
        }

        private JerseyEurekaHttpClientFactory buildExperimental(Map<String, String> additionalHeaders) {
            ThreadSafeClientConnManager cm = this.createConnectionManager();
            DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
            if (this.proxyHost != null) {
                this.addProxyConfiguration((ClientConfig)clientConfig);
            }
            DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(this.encoderWrapper, this.decoderWrapper);
            clientConfig.getSingletons().add(discoveryJerseyProvider);
            cm.setDefaultMaxPerRoute(this.maxConnectionsPerHost);
            cm.setMaxTotal(this.maxTotalConnections);
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
            String fullUserAgentName = (this.userAgent == null ? this.clientName : this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
            clientConfig.getProperties().put("http.useragent", fullUserAgentName);
            clientConfig.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
            clientConfig.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
            ApacheHttpClient4 apacheClient = ApacheHttpClient4.create((ClientConfig)clientConfig);
            this.addFilters(apacheClient);
            return new JerseyEurekaHttpClientFactory(apacheClient, this.connectionIdleTimeout, additionalHeaders);
        }

        private ThreadSafeClientConnManager createConnectionManager() {
            try {
                ThreadSafeClientConnManager connectionManager;
                if (this.sslContext != null) {
                    SSLSocketFactory socketFactory = new SSLSocketFactory(this.sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
                    SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                    sslSchemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
                    connectionManager = new ThreadSafeClientConnManager(sslSchemeRegistry);
                } else {
                    connectionManager = new ThreadSafeClientConnManager();
                }
                return connectionManager;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot initialize Apache connection manager", e);
            }
        }

        private void addProxyConfiguration(ClientConfig clientConfig) {
            if (this.proxyUserName != null && this.proxyPassword != null) {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", this.proxyUserName);
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", this.proxyPassword);
            } else {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", "guest");
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", "guest");
            }
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + this.proxyHost + ':' + this.proxyPort);
        }

        private void addFilters(ApacheHttpClient4 discoveryApacheClient) {
            discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
            String ip = this.myInstanceInfo == null ? null : this.myInstanceInfo.getIPAddr();
            AbstractEurekaIdentity identity = this.clientIdentity == null ? new EurekaClientIdentity(ip) : this.clientIdentity;
            discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter(identity));
            if (this.additionalFilters != null) {
                for (ClientFilter filter : this.additionalFilters) {
                    if (filter == null) continue;
                    discoveryApacheClient.addFilter(filter);
                }
            }
        }
    }
}

