/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.discovery.util.SpectatorUtil;
import com.netflix.spectator.api.Counter;
import java.util.concurrent.ConcurrentHashMap;

public class ExceptionsMetric {
    private final String name;
    private final ConcurrentHashMap<String, Counter> exceptionCounters = new ConcurrentHashMap();

    public ExceptionsMetric(String name) {
        this.name = name;
    }

    public void count(Throwable ex) {
        this.getOrCreateCounter(ExceptionsMetric.extractName(ex)).increment();
    }

    public void shutdown() {
    }

    private Counter getOrCreateCounter(String exceptionName) {
        Counter counter = this.exceptionCounters.get(exceptionName);
        if (counter != null) {
            return counter;
        }
        return this.exceptionCounters.computeIfAbsent(exceptionName, s -> SpectatorUtil.counter(this.name, exceptionName, ExceptionsMetric.class));
    }

    private static String extractName(Throwable ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause.getClass().getSimpleName();
    }
}

