/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo.providers;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.appinfo.Archaius2AmazonInfoConfig;
import com.netflix.appinfo.Ec2EurekaArchaius2InstanceConfig;
import com.netflix.appinfo.EurekaArchaius2InstanceConfig;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.providers.EurekaInstanceConfigFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.internal.util.AmazonInfoUtils;
import com.netflix.discovery.internal.util.InternalPrefixedConfig;
import java.net.SocketTimeoutException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ConfigurationSource(value={"eureka-client"})
public class CompositeInstanceConfigFactory
implements EurekaInstanceConfigFactory {
    private static final Logger logger = LoggerFactory.getLogger(CompositeInstanceConfigFactory.class);
    private static final String DEPLOYMENT_ENVIRONMENT_OVERRIDE_KEY = "instanceDeploymentEnvironment";
    private final String namespace;
    private final Config configInstance;
    private final InternalPrefixedConfig prefixedConfig;
    private EurekaInstanceConfig eurekaInstanceConfig;

    @Inject
    public CompositeInstanceConfigFactory(Config configInstance, String namespace) {
        this.configInstance = configInstance;
        this.namespace = namespace;
        this.prefixedConfig = new InternalPrefixedConfig(configInstance, namespace);
    }

    @Override
    public synchronized EurekaInstanceConfig get() {
        if (this.eurekaInstanceConfig == null) {
            Archaius2AmazonInfoConfig amazonInfoConfig = new Archaius2AmazonInfoConfig(this.configInstance, this.namespace);
            if (this.isInEc2(amazonInfoConfig)) {
                this.eurekaInstanceConfig = new Ec2EurekaArchaius2InstanceConfig(this.configInstance, amazonInfoConfig, this.namespace);
                logger.info("Creating EC2 specific instance config");
            } else {
                this.eurekaInstanceConfig = new EurekaArchaius2InstanceConfig(this.configInstance, this.namespace);
                logger.info("Creating generic instance config");
            }
            DiscoveryManager.getInstance().setEurekaInstanceConfig(this.eurekaInstanceConfig);
        }
        return this.eurekaInstanceConfig;
    }

    private boolean isInEc2(AmazonInfoConfig amazonInfoConfig) {
        String deploymentEnvironmentOverride = this.getDeploymentEnvironmentOverride();
        if (deploymentEnvironmentOverride == null) {
            return this.autoDetectEc2(amazonInfoConfig);
        }
        if ("ec2".equalsIgnoreCase(deploymentEnvironmentOverride)) {
            logger.info("Assuming EC2 deployment environment due to config override");
            return true;
        }
        return false;
    }

    private boolean autoDetectEc2(AmazonInfoConfig amazonInfoConfig) {
        try {
            URL url = AmazonInfo.MetaDataKey.instanceId.getURL(null, null);
            String id = AmazonInfoUtils.readEc2MetadataUrl((AmazonInfo.MetaDataKey)AmazonInfo.MetaDataKey.instanceId, (URL)url, (int)amazonInfoConfig.getConnectTimeout(), (int)amazonInfoConfig.getReadTimeout());
            if (id != null) {
                logger.info("Auto detected EC2 deployment environment, instanceId = {}", (Object)id);
                return true;
            }
            logger.info("Auto detected non-EC2 deployment environment, instanceId from metadata url is null");
            return false;
        }
        catch (SocketTimeoutException e) {
            logger.info("Auto detected non-EC2 deployment environment, connection to ec2 instance metadata url failed.");
        }
        catch (Exception e) {
            logger.warn("Failed to auto-detect whether we are in EC2 due to unexpected exception", (Throwable)e);
        }
        return false;
    }

    private String getDeploymentEnvironmentOverride() {
        return this.prefixedConfig.getString(DEPLOYMENT_ENVIRONMENT_OVERRIDE_KEY, null);
    }
}

