/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.Archaius2VipAddressResolver;
import com.netflix.appinfo.providers.CompositeInstanceConfigFactory;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.appinfo.providers.EurekaInstanceConfigFactory;
import com.netflix.appinfo.providers.VipAddressResolver;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaArchaius2ClientConfig;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EndpointRandomizer;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.transport.EurekaArchaius2TransportConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.jersey.Jersey1DiscoveryClientOptionalArgs;
import javax.inject.Named;
import javax.inject.Singleton;

final class InternalEurekaClientModule
extends AbstractModule {
    static final String INSTANCE_CONFIG_NAMESPACE_KEY = "eureka.instance.config.namespace";
    static final String CLIENT_CONFIG_NAMESPACE_KEY = "eureka.client.config.namespace";

    InternalEurekaClientModule() {
    }

    protected void configure() {
        this.requireBinding(Config.class);
        this.bind(ApplicationInfoManager.class).asEagerSingleton();
        this.bind(VipAddressResolver.class).to(Archaius2VipAddressResolver.class);
        this.bind(InstanceInfo.class).toProvider(EurekaConfigBasedInstanceInfoProvider.class);
        this.bind(EurekaClient.class).to(DiscoveryClient.class);
        this.bind(EndpointRandomizer.class).toInstance(ResolverUtils::randomize);
        this.bind(AbstractDiscoveryClientOptionalArgs.class).to(Jersey1DiscoveryClientOptionalArgs.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public EurekaTransportConfig getEurekaTransportConfig(Config config, ModuleConfig moduleConfig, EurekaConfigLoader configLoader) {
        return new EurekaArchaius2TransportConfig(config, moduleConfig.getClientConfigNamespace());
    }

    @Provides
    @Singleton
    public EurekaClientConfig getEurekaClientConfig(Config config, EurekaTransportConfig transportConfig, ModuleConfig moduleConfig, EurekaConfigLoader configLoader) {
        return new EurekaArchaius2ClientConfig(config, transportConfig, moduleConfig.getClientConfigNamespace());
    }

    @Provides
    @Singleton
    public EurekaInstanceConfig getEurekaInstanceConfigProvider(ModuleConfig moduleConfig, EurekaConfigLoader configLoader) {
        return moduleConfig.getInstanceConfigProvider().get();
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    @ConfigurationSource(value={"eureka-client"})
    private static class EurekaConfigLoader {
        private EurekaConfigLoader() {
        }
    }

    @Singleton
    static class ModuleConfig {
        @Inject
        Config config;
        @Inject(optional=true)
        @Named(value="eureka.instance.config.namespace")
        String instanceConfigNamespace;
        @Inject(optional=true)
        @Named(value="eureka.client.config.namespace")
        String clientConfigNamespace;
        @Inject(optional=true)
        EurekaInstanceConfigFactory instanceConfigFactory;

        ModuleConfig() {
        }

        String getInstanceConfigNamespace() {
            return this.instanceConfigNamespace == null ? "eureka" : this.instanceConfigNamespace;
        }

        String getClientConfigNamespace() {
            return this.clientConfigNamespace == null ? "eureka" : this.clientConfigNamespace;
        }

        EurekaInstanceConfigFactory getInstanceConfigProvider() {
            return this.instanceConfigFactory == null ? new CompositeInstanceConfigFactory(this.config, this.getInstanceConfigNamespace()) : this.instanceConfigFactory;
        }
    }
}

