/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.internal.util;

import com.netflix.archaius.api.Config;
import java.util.Iterator;

public final class InternalPrefixedConfig {
    private final Config config;
    private final String namespace;

    public InternalPrefixedConfig(Config config, String ... namespaces) {
        this.config = config;
        String tempNamespace = "";
        for (String namespace : namespaces) {
            if (namespace == null || namespace.isEmpty()) continue;
            tempNamespace = tempNamespace + (namespace.endsWith(".") ? namespace : namespace + ".");
        }
        this.namespace = tempNamespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getString(String key, String defaultValue) {
        return this.config.getString(this.namespace + key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.config.getInteger(this.namespace + key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.config.getLong(this.namespace + key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.config.getDouble(this.namespace + key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.config.getBoolean(this.namespace + key, defaultValue);
    }

    public Iterator<String> getKeys() {
        final String prefixRegex = "^" + this.namespace;
        final Iterator internalIterator = this.config.getKeys(this.namespace);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return internalIterator.hasNext();
            }

            @Override
            public String next() {
                String value = (String)internalIterator.next();
                return value.replaceFirst(prefixRegex, "");
            }
        };
    }
}

