/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.internal.util.InternalPrefixedConfig;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ConfigurationSource(value={"eureka-client"})
public class Archaius2AmazonInfoConfig
implements AmazonInfoConfig {
    private final Config configInstance;
    private final InternalPrefixedConfig prefixedConfig;
    private final String namespace;

    @Inject
    public Archaius2AmazonInfoConfig(Config configInstance) {
        this(configInstance, "eureka");
    }

    public Archaius2AmazonInfoConfig(Config configInstance, String namespace) {
        this.namespace = namespace;
        this.configInstance = configInstance;
        this.prefixedConfig = new InternalPrefixedConfig(configInstance, namespace);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean shouldLogAmazonMetadataErrors() {
        return this.prefixedConfig.getBoolean("logAmazonMetadataErrors", false);
    }

    public int getReadTimeout() {
        return this.prefixedConfig.getInteger("mt.read_timeout", 5000);
    }

    public int getConnectTimeout() {
        return this.prefixedConfig.getInteger("mt.connect_timeout", 2000);
    }

    public int getNumRetries() {
        return this.prefixedConfig.getInteger("mt.num_retries", 3);
    }

    public boolean shouldFailFastOnFirstLoad() {
        return this.prefixedConfig.getBoolean("mt.fail_fast_on_first_load", true);
    }

    public boolean shouldValidateInstanceId() {
        return this.prefixedConfig.getBoolean("validateInstanceId", true);
    }
}

