/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.appinfo.Archaius2AmazonInfoConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaArchaius2InstanceConfig;
import com.netflix.appinfo.RefreshableAmazonInfoProvider;
import com.netflix.appinfo.RefreshableInstanceConfig;
import com.netflix.archaius.api.Config;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Ec2EurekaArchaius2InstanceConfig
extends EurekaArchaius2InstanceConfig
implements RefreshableInstanceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(Ec2EurekaArchaius2InstanceConfig.class);
    private static final String[] DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER = new String[]{AmazonInfo.MetaDataKey.publicHostname.name(), AmazonInfo.MetaDataKey.localIpv4.name()};
    private final AmazonInfoConfig amazonInfoConfig;
    private final RefreshableAmazonInfoProvider amazonInfoHolder;

    @Inject
    public Ec2EurekaArchaius2InstanceConfig(Config configInstance, AmazonInfoConfig amazonInfoConfig) {
        this(configInstance, amazonInfoConfig, "eureka");
    }

    Ec2EurekaArchaius2InstanceConfig(Config configInstance, AmazonInfo info) {
        this(configInstance, new Archaius2AmazonInfoConfig(configInstance), "eureka", info, false);
    }

    public Ec2EurekaArchaius2InstanceConfig(Config configInstance, AmazonInfoConfig amazonInfoConfig, String namespace) {
        this(configInstance, amazonInfoConfig, namespace, null, true);
    }

    Ec2EurekaArchaius2InstanceConfig(Config configInstance, AmazonInfoConfig amazonInfoConfig, String namespace, AmazonInfo initialInfo, boolean eagerInit) {
        super(configInstance, namespace);
        this.amazonInfoConfig = amazonInfoConfig;
        if (eagerInit) {
            RefreshableAmazonInfoProvider.FallbackAddressProvider fallbackAddressProvider = new RefreshableAmazonInfoProvider.FallbackAddressProvider(){

                public String getFallbackIp() {
                    return Ec2EurekaArchaius2InstanceConfig.super.getIpAddress();
                }

                public String getFallbackHostname() {
                    return Ec2EurekaArchaius2InstanceConfig.super.getHostName(false);
                }
            };
            this.amazonInfoHolder = new RefreshableAmazonInfoProvider(amazonInfoConfig, fallbackAddressProvider);
        } else {
            this.amazonInfoHolder = new RefreshableAmazonInfoProvider(initialInfo, amazonInfoConfig);
        }
    }

    public String getHostName(boolean refresh) {
        if (refresh) {
            this.amazonInfoHolder.refresh();
        }
        return this.amazonInfoHolder.get().get(AmazonInfo.MetaDataKey.publicHostname);
    }

    @Override
    public DataCenterInfo getDataCenterInfo() {
        return this.amazonInfoHolder.get();
    }

    @Override
    public String[] getDefaultAddressResolutionOrder() {
        String[] order = super.getDefaultAddressResolutionOrder();
        return order.length == 0 ? DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER : order;
    }

    @Deprecated
    public synchronized void refreshAmazonInfo() {
        this.amazonInfoHolder.refresh();
    }

    public String resolveDefaultAddress(boolean refresh) {
        String result = this.getHostName(refresh);
        for (String name : this.getDefaultAddressResolutionOrder()) {
            try {
                AmazonInfo.MetaDataKey key = AmazonInfo.MetaDataKey.valueOf((String)name);
                String address = this.amazonInfoHolder.get().get(key);
                if (address == null || address.isEmpty()) continue;
                result = address;
                break;
            }
            catch (Exception e) {
                LOG.error("failed to resolve default address for key {}, skipping", (Object)name, (Object)e);
            }
        }
        return result;
    }
}

