/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.inject.Inject;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.internal.util.InternalPrefixedConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;

@Singleton
@ConfigurationSource(value={"eureka-client"})
public class EurekaArchaius2ClientConfig
implements EurekaClientConfig {
    public static final String DEFAULT_ZONE = "defaultZone";
    private static final String DEFAULT_NAMESPACE = "eureka";
    private final Config configInstance;
    private final InternalPrefixedConfig prefixedConfig;
    private final EurekaTransportConfig transportConfig;

    @Inject
    public EurekaArchaius2ClientConfig(Config configInstance, EurekaTransportConfig transportConfig) {
        this(configInstance, transportConfig, DEFAULT_NAMESPACE);
    }

    public EurekaArchaius2ClientConfig(Config configInstance, EurekaTransportConfig transportConfig, String namespace) {
        this.transportConfig = transportConfig;
        this.configInstance = configInstance;
        this.prefixedConfig = new InternalPrefixedConfig(configInstance, namespace);
    }

    public int getRegistryFetchIntervalSeconds() {
        return this.prefixedConfig.getInteger("client.refresh.interval", 30);
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.prefixedConfig.getInteger("appinfo.replicate.interval", 30);
    }

    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.prefixedConfig.getInteger("appinfo.initial.replicate.time", 40);
    }

    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.prefixedConfig.getInteger("serviceUrlPollIntervalMs", 300);
    }

    public String getProxyHost() {
        return this.prefixedConfig.getString("eurekaServer.proxyHost", null);
    }

    public String getProxyPort() {
        return this.prefixedConfig.getString("eurekaServer.proxyPort", null);
    }

    public String getProxyUserName() {
        return this.prefixedConfig.getString("eurekaServer.proxyUserName", null);
    }

    public String getProxyPassword() {
        return this.prefixedConfig.getString("eurekaServer.proxyPassword", null);
    }

    public boolean shouldGZipContent() {
        return this.prefixedConfig.getBoolean("eurekaServer.gzipContent", true);
    }

    public int getEurekaServerReadTimeoutSeconds() {
        return this.prefixedConfig.getInteger("eurekaServer.readTimeout", 8);
    }

    public int getEurekaServerConnectTimeoutSeconds() {
        return this.prefixedConfig.getInteger("eurekaServer.connectTimeout", 5);
    }

    public String getBackupRegistryImpl() {
        return this.prefixedConfig.getString("backupregistry", null);
    }

    public int getEurekaServerTotalConnections() {
        return this.prefixedConfig.getInteger("eurekaServer.maxTotalConnections", 200);
    }

    public int getEurekaServerTotalConnectionsPerHost() {
        return this.prefixedConfig.getInteger("eurekaServer.maxConnectionsPerHost", 50);
    }

    public String getEurekaServerURLContext() {
        return this.prefixedConfig.getString("eurekaServer.context", null);
    }

    public String getEurekaServerPort() {
        return this.prefixedConfig.getString("eurekaServer.port", this.prefixedConfig.getString("port", null));
    }

    public String getEurekaServerDNSName() {
        return this.prefixedConfig.getString("eurekaServer.domainName", this.prefixedConfig.getString("domainName", null));
    }

    public boolean shouldUseDnsForFetchingServiceUrls() {
        return this.prefixedConfig.getBoolean("shouldUseDns", false);
    }

    public boolean shouldRegisterWithEureka() {
        return this.prefixedConfig.getBoolean("registration.enabled", true);
    }

    public boolean shouldUnregisterOnShutdown() {
        return this.prefixedConfig.getBoolean("shouldUnregisterOnShutdown", true);
    }

    public boolean shouldPreferSameZoneEureka() {
        return this.prefixedConfig.getBoolean("preferSameZone", true);
    }

    public boolean allowRedirects() {
        return this.prefixedConfig.getBoolean("allowRedirects", false);
    }

    public boolean shouldLogDeltaDiff() {
        return this.prefixedConfig.getBoolean("printDeltaFullDiff", false);
    }

    public boolean shouldDisableDelta() {
        return this.prefixedConfig.getBoolean("disableDelta", false);
    }

    public String fetchRegistryForRemoteRegions() {
        return this.prefixedConfig.getString("fetchRemoteRegionsRegistry", null);
    }

    public String getRegion() {
        return this.prefixedConfig.getString("region", this.prefixedConfig.getString("eureka.region", "us-east-1"));
    }

    public String[] getAvailabilityZones(String region) {
        return this.prefixedConfig.getString(String.format("%s.availabilityZones", region), DEFAULT_ZONE).split(",");
    }

    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = this.prefixedConfig.getString("serviceUrl." + myZone, null);
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = this.prefixedConfig.getString("serviceUrl.default", null);
        }
        return serviceUrls != null ? Arrays.asList(serviceUrls.split(",")) : Collections.emptyList();
    }

    public boolean shouldFilterOnlyUpInstances() {
        return this.prefixedConfig.getBoolean("shouldFilterOnlyUpInstances", true);
    }

    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.prefixedConfig.getInteger("eurekaserver.connectionIdleTimeoutInSeconds", 30);
    }

    public boolean shouldFetchRegistry() {
        return this.prefixedConfig.getBoolean("shouldFetchRegistry", true);
    }

    public String getRegistryRefreshSingleVipAddress() {
        return this.prefixedConfig.getString("registryRefreshSingleVipAddress", null);
    }

    public int getHeartbeatExecutorThreadPoolSize() {
        return this.prefixedConfig.getInteger("client.heartbeat.threadPoolSize", 5);
    }

    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.prefixedConfig.getInteger("client.heartbeat.exponentialBackOffBound", 10);
    }

    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.prefixedConfig.getInteger("client.cacheRefresh.threadPoolSize", 5);
    }

    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.prefixedConfig.getInteger("client.cacheRefresh.exponentialBackOffBound", 10);
    }

    public String getDollarReplacement() {
        return this.prefixedConfig.getString("dollarReplacement", "_-");
    }

    public String getEscapeCharReplacement() {
        return this.prefixedConfig.getString("escapeCharReplacement", "__");
    }

    public boolean shouldOnDemandUpdateStatusChange() {
        return this.prefixedConfig.getBoolean("shouldOnDemandUpdateStatusChange", true);
    }

    public boolean shouldEnforceRegistrationAtInit() {
        return this.prefixedConfig.getBoolean("shouldEnforceRegistrationAtInit", false);
    }

    public String getEncoderName() {
        return this.prefixedConfig.getString("encoderName", null);
    }

    public String getDecoderName() {
        return this.prefixedConfig.getString("decoderName", null);
    }

    public String getClientDataAccept() {
        return this.prefixedConfig.getString("clientDataAccept", EurekaAccept.full.name());
    }

    public String getExperimental(String name) {
        return this.prefixedConfig.getString("experimental." + name, null);
    }

    public EurekaTransportConfig getTransportConfig() {
        return this.transportConfig;
    }
}

