/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.google.inject.Inject;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.internal.util.InternalPrefixedConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import javax.inject.Singleton;

@Singleton
@ConfigurationSource(value={"eureka-client"})
public class EurekaArchaius2TransportConfig
implements EurekaTransportConfig {
    private final Config configInstance;
    private final InternalPrefixedConfig prefixedConfig;

    @Inject
    public EurekaArchaius2TransportConfig(Config configInstance) {
        this(configInstance, "eureka", "transport");
    }

    public EurekaArchaius2TransportConfig(Config configInstance, String parentNamespace) {
        this(configInstance, parentNamespace, "transport");
    }

    public EurekaArchaius2TransportConfig(Config configInstance, String parentNamespace, String subNamespace) {
        this.configInstance = configInstance;
        this.prefixedConfig = new InternalPrefixedConfig(configInstance, parentNamespace, subNamespace);
    }

    public int getSessionedClientReconnectIntervalSeconds() {
        return this.prefixedConfig.getInteger("sessionedClientReconnectIntervalSeconds", 1200);
    }

    public double getRetryableClientQuarantineRefreshPercentage() {
        return this.prefixedConfig.getDouble("retryableClientQuarantineRefreshPercentage", 0.66);
    }

    public int getApplicationsResolverDataStalenessThresholdSeconds() {
        return this.prefixedConfig.getInteger("applicationsResolverDataStalenessThresholdSeconds", 300);
    }

    public boolean applicationsResolverUseIp() {
        return this.prefixedConfig.getBoolean("applicationsResolverUseIp", false);
    }

    public int getAsyncResolverRefreshIntervalMs() {
        return this.prefixedConfig.getInteger("asyncResolverRefreshIntervalMs", 300000);
    }

    public int getAsyncResolverWarmUpTimeoutMs() {
        return this.prefixedConfig.getInteger("asyncResolverWarmupTimeoutMs", 5000);
    }

    public int getAsyncExecutorThreadPoolSize() {
        return this.prefixedConfig.getInteger("asyncExecutorThreadPoolSize", 5);
    }

    public String getWriteClusterVip() {
        return this.prefixedConfig.getString("writeClusterVip", null);
    }

    public String getReadClusterVip() {
        return this.prefixedConfig.getString("readClusterVip", null);
    }

    public String getBootstrapResolverStrategy() {
        return this.prefixedConfig.getString("bootstrapResolverStrategy", null);
    }

    public boolean useBootstrapResolverForQuery() {
        return this.prefixedConfig.getBoolean("useBootstrapResolverForQuery", true);
    }
}

