/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.google.common.collect.Sets;
import com.netflix.appinfo.AbstractInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.discovery.internal.util.InternalPrefixedConfig;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ConfigurationSource(value={"eureka-client"})
public class EurekaArchaius2InstanceConfig
extends AbstractInstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(EurekaArchaius2InstanceConfig.class);
    protected String namespace;
    private final Config configInstance;
    private final InternalPrefixedConfig prefixedConfig;
    private final DataCenterInfo dcInfo;
    private final String defaultAppGroup;

    @Inject
    public EurekaArchaius2InstanceConfig(Config configInstance) {
        this(configInstance, "eureka");
    }

    public EurekaArchaius2InstanceConfig(Config configInstance, String namespace) {
        this(configInstance, namespace, new DataCenterInfo(){

            public DataCenterInfo.Name getName() {
                return DataCenterInfo.Name.MyOwn;
            }
        });
    }

    public EurekaArchaius2InstanceConfig(Config configInstance, String namespace, DataCenterInfo dcInfo) {
        this.defaultAppGroup = configInstance.getString("NETFLIX_APP_GROUP", "unknown");
        this.namespace = namespace;
        this.configInstance = configInstance;
        this.prefixedConfig = new InternalPrefixedConfig(configInstance, namespace);
        this.dcInfo = dcInfo;
    }

    public String getInstanceId() {
        String result = this.prefixedConfig.getString("instanceId", null);
        return result == null ? null : result.trim();
    }

    public String getAppname() {
        return this.prefixedConfig.getString("name", "unknown").trim();
    }

    public String getAppGroupName() {
        return this.prefixedConfig.getString("appGroup", this.defaultAppGroup).trim();
    }

    public boolean isInstanceEnabledOnit() {
        return this.prefixedConfig.getBoolean("traffic.enabled", super.isInstanceEnabledOnit());
    }

    public int getNonSecurePort() {
        return this.prefixedConfig.getInteger("port", super.getNonSecurePort());
    }

    public int getSecurePort() {
        return this.prefixedConfig.getInteger("securePort", super.getSecurePort());
    }

    public boolean isNonSecurePortEnabled() {
        return this.prefixedConfig.getBoolean("port.enabled", super.isNonSecurePortEnabled());
    }

    public boolean getSecurePortEnabled() {
        return this.prefixedConfig.getBoolean("securePort.enabled", super.getSecurePortEnabled());
    }

    public int getLeaseRenewalIntervalInSeconds() {
        return this.prefixedConfig.getInteger("lease.renewalInterval", super.getLeaseRenewalIntervalInSeconds());
    }

    public int getLeaseExpirationDurationInSeconds() {
        return this.prefixedConfig.getInteger("lease.duration", super.getLeaseExpirationDurationInSeconds());
    }

    public String getVirtualHostName() {
        return this.isNonSecurePortEnabled() ? this.prefixedConfig.getString("vipAddress", super.getVirtualHostName()) : null;
    }

    public String getSecureVirtualHostName() {
        return this.getSecurePortEnabled() ? this.prefixedConfig.getString("secureVipAddress", super.getSecureVirtualHostName()) : null;
    }

    public String getASGName() {
        return this.prefixedConfig.getString("asgName", super.getASGName());
    }

    public Map<String, String> getMetadataMap() {
        HashMap<String, String> meta = new HashMap<String, String>();
        InternalPrefixedConfig metadataConfig = new InternalPrefixedConfig(this.configInstance, this.namespace, "metadata");
        for (String key : Sets.newHashSet(metadataConfig.getKeys())) {
            String value = metadataConfig.getString(key, null);
            if (value != null && !value.isEmpty()) {
                meta.put(key, value);
                continue;
            }
            logger.warn("Not adding metadata with key \"{}\" as it has null or empty value", (Object)key);
        }
        return meta;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dcInfo;
    }

    public String getStatusPageUrlPath() {
        return this.prefixedConfig.getString("statusPageUrlPath", "/Status");
    }

    public String getStatusPageUrl() {
        return this.prefixedConfig.getString("statusPageUrl", null);
    }

    public String getHomePageUrlPath() {
        return this.prefixedConfig.getString("homePageUrlPath", "/");
    }

    public String getHomePageUrl() {
        return this.prefixedConfig.getString("homePageUrl", null);
    }

    public String getHealthCheckUrlPath() {
        return this.prefixedConfig.getString("healthCheckUrlPath", "/healthcheck");
    }

    public String getHealthCheckUrl() {
        return this.prefixedConfig.getString("healthCheckUrl", null);
    }

    public String getSecureHealthCheckUrl() {
        return this.prefixedConfig.getString("secureHealthCheckUrl", null);
    }

    public String[] getDefaultAddressResolutionOrder() {
        String result = this.prefixedConfig.getString("defaultAddressResolutionOrder", null);
        return result == null ? new String[]{} : result.split(",");
    }

    public String getNamespace() {
        return this.namespace;
    }
}

