/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo.providers;

import com.netflix.appinfo.providers.VipAddressResolver;
import com.netflix.archaius.api.Config;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Archaius2VipAddressResolver
implements VipAddressResolver {
    private static final Logger logger = LoggerFactory.getLogger(Archaius2VipAddressResolver.class);
    private static final Pattern VIP_ATTRIBUTES_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private final Config config;

    @Inject
    public Archaius2VipAddressResolver(Config config) {
        this.config = config;
    }

    public String resolveDeploymentContextBasedVipAddresses(String vipAddressMacro) {
        if (vipAddressMacro == null) {
            return null;
        }
        String result = vipAddressMacro;
        Matcher matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = this.config.getString(key, "");
            logger.debug("att:{}", (Object)matcher.group());
            logger.debug(", att key:{}", (Object)key);
            logger.debug(", att value:{}", (Object)value);
            logger.debug("");
            result = result.replaceAll("\\$\\{" + key + "\\}", value);
            matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        }
        return result;
    }
}

