/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey2;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.transport.jersey2.EurekaJersey2Client;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJersey2ClientImpl
implements EurekaJersey2Client {
    private static final Logger s_logger = LoggerFactory.getLogger(EurekaJersey2ClientImpl.class);
    private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
    private static final String PROTOCOL = "https";
    private static final String PROTOCOL_SCHEME = "SSL";
    private static final int HTTPS_PORT = 443;
    private static final String KEYSTORE_TYPE = "JKS";
    private final Client apacheHttpClient;
    private final ConnectionCleanerTask connectionCleanerTask;
    ClientConfig jerseyClientConfig;
    private final ScheduledExecutorService eurekaConnCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Eureka-Jersey2Client-Conn-Cleaner" + this.threadNumber.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });

    public EurekaJersey2ClientImpl(int connectionTimeout, int readTimeout, int connectionIdleTimeout, ClientConfig clientConfig) {
        try {
            this.jerseyClientConfig = clientConfig;
            this.jerseyClientConfig.register(DiscoveryJerseyProvider.class);
            this.jerseyClientConfig.property("jersey.config.client.disableJsonProcessing", (Object)Boolean.TRUE);
            this.jerseyClientConfig.property("jersey.config.client.disableMoxyJson", (Object)Boolean.TRUE);
            this.jerseyClientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            this.jerseyClientConfig.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
            this.jerseyClientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
            this.apacheHttpClient = ClientBuilder.newClient((Configuration)this.jerseyClientConfig);
            this.connectionCleanerTask = new ConnectionCleanerTask(connectionIdleTimeout);
            this.eurekaConnCleaner.scheduleWithFixedDelay(this.connectionCleanerTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey2 client", e);
        }
    }

    @Override
    public Client getClient() {
        return this.apacheHttpClient;
    }

    @Override
    public void destroyResources() {
        if (this.eurekaConnCleaner != null) {
            this.eurekaConnCleaner.execute(this.connectionCleanerTask);
            this.eurekaConnCleaner.shutdown();
        }
        if (this.apacheHttpClient != null) {
            this.apacheHttpClient.close();
        }
    }

    private class ConnectionCleanerTask
    implements Runnable {
        private final int connectionIdleTimeout;
        private final BasicTimer executionTimeStats;
        private final Counter cleanupFailed;

        private ConnectionCleanerTask(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Time");
            this.executionTimeStats = new BasicTimer(monitorConfigBuilder.build());
            this.cleanupFailed = new BasicCounter(MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Failure").build());
            try {
                Monitors.registerObject((Object)this);
            }
            catch (Exception e) {
                s_logger.error("Unable to register with servo.", (Throwable)e);
            }
        }

        @Override
        public void run() {
            Stopwatch start = this.executionTimeStats.start();
            try {
                HttpClientConnectionManager cm = (HttpClientConnectionManager)EurekaJersey2ClientImpl.this.apacheHttpClient.getConfiguration().getProperty("jersey.config.apache.client.connectionManager");
                cm.closeIdleConnections((long)this.connectionIdleTimeout, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                s_logger.error("Cannot clean connections", e);
                this.cleanupFailed.increment();
            }
            finally {
                if (null != start) {
                    start.stop();
                }
            }
        }
    }

    public static class EurekaJersey2ClientBuilder {
        private boolean systemSSL;
        private String clientName;
        private int maxConnectionsPerHost;
        private int maxTotalConnections;
        private String trustStoreFileName;
        private String trustStorePassword;
        private String userAgent;
        private String proxyUserName;
        private String proxyPassword;
        private String proxyHost;
        private String proxyPort;
        private int connectionTimeout;
        private int readTimeout;
        private int connectionIdleTimeout;
        private EncoderWrapper encoderWrapper;
        private DecoderWrapper decoderWrapper;

        public EurekaJersey2ClientBuilder withClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EurekaJersey2ClientBuilder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public EurekaJersey2ClientBuilder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public EurekaJersey2ClientBuilder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public EurekaJersey2ClientBuilder withConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public EurekaJersey2ClientBuilder withMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public EurekaJersey2ClientBuilder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public EurekaJersey2ClientBuilder withProxy(String proxyHost, String proxyPort, String user, String password) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUserName = user;
            this.proxyPassword = password;
            return this;
        }

        public EurekaJersey2ClientBuilder withSystemSSLConfiguration() {
            this.systemSSL = true;
            return this;
        }

        public EurekaJersey2ClientBuilder withTrustStoreFile(String trustStoreFileName, String trustStorePassword) {
            this.trustStoreFileName = trustStoreFileName;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public EurekaJersey2ClientBuilder withEncoder(String encoderName) {
            return this.withEncoderWrapper(CodecWrappers.getEncoder((String)encoderName));
        }

        public EurekaJersey2ClientBuilder withEncoderWrapper(EncoderWrapper encoderWrapper) {
            this.encoderWrapper = encoderWrapper;
            return this;
        }

        public EurekaJersey2ClientBuilder withDecoder(String decoderName, String clientDataAccept) {
            return this.withDecoderWrapper(CodecWrappers.resolveDecoder((String)decoderName, (String)clientDataAccept));
        }

        public EurekaJersey2ClientBuilder withDecoderWrapper(DecoderWrapper decoderWrapper) {
            this.decoderWrapper = decoderWrapper;
            return this;
        }

        public EurekaJersey2Client build() {
            MyDefaultApacheHttpClient4Config config = new MyDefaultApacheHttpClient4Config();
            try {
                return new EurekaJersey2ClientImpl(this.connectionTimeout, this.readTimeout, this.connectionIdleTimeout, config);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client ", e);
            }
        }

        class MyDefaultApacheHttpClient4Config
        extends ClientConfig {
            MyDefaultApacheHttpClient4Config() {
                PoolingHttpClientConnectionManager cm = EurekaJersey2ClientBuilder.this.systemSSL ? this.createSystemSslCM() : (EurekaJersey2ClientBuilder.this.trustStoreFileName != null ? this.createCustomSslCM() : new PoolingHttpClientConnectionManager());
                if (EurekaJersey2ClientBuilder.this.proxyHost != null) {
                    this.addProxyConfiguration();
                }
                DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(EurekaJersey2ClientBuilder.this.encoderWrapper, EurekaJersey2ClientBuilder.this.decoderWrapper);
                this.register(discoveryJerseyProvider);
                cm.setDefaultMaxPerRoute(EurekaJersey2ClientBuilder.this.maxConnectionsPerHost);
                cm.setMaxTotal(EurekaJersey2ClientBuilder.this.maxTotalConnections);
                this.property("jersey.config.apache.client.connectionManager", cm);
                String fullUserAgentName = (EurekaJersey2ClientBuilder.this.userAgent == null ? EurekaJersey2ClientBuilder.this.clientName : EurekaJersey2ClientBuilder.this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
                this.property("http.useragent", fullUserAgentName);
                this.property("jersey.config.client.followRedirects", Boolean.FALSE);
                this.property("http.protocol.handle-redirects", Boolean.FALSE);
            }

            private void addProxyConfiguration() {
                if (EurekaJersey2ClientBuilder.this.proxyUserName != null && EurekaJersey2ClientBuilder.this.proxyPassword != null) {
                    this.property("jersey.config.client.proxy.username", EurekaJersey2ClientBuilder.this.proxyUserName);
                    this.property("jersey.config.client.proxy.password", EurekaJersey2ClientBuilder.this.proxyPassword);
                } else {
                    this.property("jersey.config.client.proxy.username", "guest");
                    this.property("jersey.config.client.proxy.password", "guest");
                }
                this.property("jersey.config.client.proxy.uri", "http://" + EurekaJersey2ClientBuilder.this.proxyHost + ":" + EurekaJersey2ClientBuilder.this.proxyPort);
            }

            private PoolingHttpClientConnectionManager createSystemSslCM() {
                SSLConnectionSocketFactory socketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
                Registry registry = RegistryBuilder.create().register(EurekaJersey2ClientImpl.PROTOCOL, (Object)socketFactory).build();
                return new PoolingHttpClientConnectionManager(registry);
            }

            private PoolingHttpClientConnectionManager createCustomSslCM() {
                FileInputStream fin = null;
                try {
                    SSLContext sslContext = SSLContext.getInstance(EurekaJersey2ClientImpl.PROTOCOL_SCHEME);
                    KeyStore sslKeyStore = KeyStore.getInstance(EurekaJersey2ClientImpl.KEYSTORE_TYPE);
                    fin = new FileInputStream(EurekaJersey2ClientBuilder.this.trustStoreFileName);
                    sslKeyStore.load(fin, EurekaJersey2ClientBuilder.this.trustStorePassword.toCharArray());
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init(sslKeyStore);
                    TrustManager[] trustManagers = factory.getTrustManagers();
                    sslContext.init(null, trustManagers, null);
                    SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    Registry registry = RegistryBuilder.create().register(EurekaJersey2ClientImpl.PROTOCOL, (Object)socketFactory).build();
                    PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                    return poolingHttpClientConnectionManager;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("SSL configuration issue", ex);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

