/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey2;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaClientFactoryBuilder;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey2.Jersey2ApplicationClient;
import com.netflix.discovery.shared.transport.jersey2.Jersey2EurekaIdentityHeaderFilter;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.message.GZipEncoder;

public class Jersey2ApplicationClientFactory
implements TransportClientFactory {
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final String KEY_STORE_TYPE = "JKS";
    private final Client jersey2Client;
    private final MultivaluedMap<String, Object> additionalHeaders;

    public Jersey2ApplicationClientFactory(Client jersey2Client, MultivaluedMap<String, Object> additionalHeaders) {
        this.jersey2Client = jersey2Client;
        this.additionalHeaders = additionalHeaders;
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new Jersey2ApplicationClient(this.jersey2Client, endpoint.getServiceUrl(), this.additionalHeaders);
    }

    public void shutdown() {
        this.jersey2Client.close();
    }

    public static Jersey2ApplicationClientFactory create(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo, AbstractEurekaIdentity clientIdentity) {
        Jersey2ApplicationClientFactoryBuilder clientBuilder = Jersey2ApplicationClientFactory.newBuilder();
        clientBuilder.withAdditionalFilters(additionalFilters);
        clientBuilder.withMyInstanceInfo(myInstanceInfo);
        clientBuilder.withUserAgent("Java-EurekaClient");
        clientBuilder.withClientConfig(clientConfig);
        clientBuilder.withClientIdentity(clientIdentity);
        if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            ((Jersey2ApplicationClientFactoryBuilder)clientBuilder.withClientName("DiscoveryClient-HTTPClient-System")).withSystemSSLConfiguration();
        } else if (clientConfig.getProxyHost() != null && clientConfig.getProxyPort() != null) {
            ((Jersey2ApplicationClientFactoryBuilder)clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient")).withProxy(clientConfig.getProxyHost(), Integer.parseInt(clientConfig.getProxyPort()), clientConfig.getProxyUserName(), clientConfig.getProxyPassword());
        } else {
            clientBuilder.withClientName("DiscoveryClient-HTTPClient");
        }
        return clientBuilder.build();
    }

    public static Jersey2ApplicationClientFactoryBuilder newBuilder() {
        return new Jersey2ApplicationClientFactoryBuilder();
    }

    public static class Jersey2ApplicationClientFactoryBuilder
    extends EurekaClientFactoryBuilder<Jersey2ApplicationClientFactory, Jersey2ApplicationClientFactoryBuilder> {
        private List<Feature> features = new ArrayList<Feature>();
        private List<ClientRequestFilter> additionalFilters = new ArrayList<ClientRequestFilter>();

        public Jersey2ApplicationClientFactoryBuilder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        Jersey2ApplicationClientFactoryBuilder withAdditionalFilters(Collection<ClientRequestFilter> additionalFilters) {
            if (additionalFilters != null) {
                this.additionalFilters.addAll(additionalFilters);
            }
            return this;
        }

        public Jersey2ApplicationClientFactory build() {
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            ClientConfig clientConfig = new ClientConfig();
            for (ClientRequestFilter filter : this.additionalFilters) {
                clientBuilder.register((Object)filter);
            }
            for (Feature feature : this.features) {
                clientConfig.register((Object)feature);
            }
            this.addProviders(clientConfig);
            this.addSSLConfiguration(clientBuilder);
            this.addProxyConfiguration(clientConfig);
            final String fullUserAgentName = (this.userAgent == null ? this.clientName : this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
            clientBuilder.register((Object)new ClientRequestFilter(){

                public void filter(ClientRequestContext requestContext) {
                    requestContext.getHeaders().put((Object)"User-Agent", Collections.singletonList(fullUserAgentName));
                }
            });
            clientConfig.property("jersey.config.client.followRedirects", (Object)this.allowRedirect);
            clientConfig.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
            clientConfig.property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout);
            clientBuilder.withConfig((Configuration)clientConfig);
            clientBuilder.register((Object)new GZipEncoder());
            String ip = this.myInstanceInfo == null ? null : this.myInstanceInfo.getIPAddr();
            EurekaClientIdentity identity = this.clientIdentity == null ? new EurekaClientIdentity(ip) : this.clientIdentity;
            clientBuilder.register((Object)new Jersey2EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
            JerseyClient jersey2Client = (JerseyClient)clientBuilder.build();
            MultivaluedHashMap additionalHeaders = new MultivaluedHashMap();
            if (this.allowRedirect) {
                additionalHeaders.add((Object)Jersey2ApplicationClientFactory.HTTP_X_DISCOVERY_ALLOW_REDIRECT, (Object)"true");
            }
            if (EurekaAccept.compact == this.eurekaAccept) {
                additionalHeaders.add((Object)"X-Eureka-Accept", (Object)this.eurekaAccept.name());
            }
            return new Jersey2ApplicationClientFactory((Client)jersey2Client, (MultivaluedMap<String, Object>)additionalHeaders);
        }

        private void addSSLConfiguration(ClientBuilder clientBuilder) {
            try {
                if (this.systemSSL) {
                    clientBuilder.sslContext(SSLContext.getDefault());
                } else if (this.trustStoreFileName != null) {
                    KeyStore trustStore = KeyStore.getInstance(Jersey2ApplicationClientFactory.KEY_STORE_TYPE);
                    FileInputStream fin = new FileInputStream(this.trustStoreFileName);
                    trustStore.load(fin, this.trustStorePassword.toCharArray());
                    clientBuilder.trustStore(trustStore);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot setup SSL for Jersey2 client", ex);
            }
        }

        private void addProxyConfiguration(ClientConfig clientConfig) {
            if (this.proxyHost != null) {
                String proxyAddress = this.proxyHost;
                if (this.proxyPort > 0) {
                    proxyAddress = proxyAddress + (58 + this.proxyPort);
                }
                clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyAddress);
                if (this.proxyUserName != null) {
                    if (this.proxyPassword == null) {
                        throw new IllegalArgumentException("Proxy user name provided but not password");
                    }
                    clientConfig.property("jersey.config.client.proxy.username", (Object)this.proxyUserName);
                    clientConfig.property("jersey.config.client.proxy.password", (Object)this.proxyPassword);
                }
            }
        }

        private void addProviders(ClientConfig clientConfig) {
            DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(this.encoderWrapper, this.decoderWrapper);
            clientConfig.register((Object)discoveryJerseyProvider);
        }
    }
}

