/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey2;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJersey2EurekaHttpClient
implements EurekaHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJersey2EurekaHttpClient.class);
    protected final Client jerseyClient;
    protected final String serviceUrl;
    private final String userName;
    private final String password;

    public AbstractJersey2EurekaHttpClient(Client jerseyClient, String serviceUrl) {
        this.jerseyClient = jerseyClient;
        this.serviceUrl = serviceUrl;
        String localUserName = null;
        String localPassword = null;
        try {
            String[] credentials;
            URI serviceURI = new URI(serviceUrl);
            if (serviceURI.getUserInfo() != null && (credentials = serviceURI.getUserInfo().split(":")).length == 2) {
                localUserName = credentials[0];
                localPassword = credentials[1];
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.userName = localUserName;
        this.password = localPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + info.getAppName();
        Response response = null;
        try {
            Invocation.Builder resourceBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).request();
            this.addExtraProperties(resourceBuilder);
            this.addExtraHeaders(resourceBuilder);
            response = resourceBuilder.accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).post(Entity.json((Object)info));
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus()).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP POST {}/{} with instance {}; statusCode={}", new Object[]{this.serviceUrl, urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP POST {}/{} with instance {}; statusCode={}", new Object[]{this.serviceUrl, urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        Response response = null;
        try {
            Invocation.Builder resourceBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).request();
            this.addExtraProperties(resourceBuilder);
            this.addExtraHeaders(resourceBuilder);
            response = resourceBuilder.delete();
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus()).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        Response response = null;
        try {
            WebTarget webResource = this.jerseyClient.target(this.serviceUrl).path(urlPath).queryParam("status", new Object[]{info.getStatus().toString()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()});
            if (overriddenStatus != null) {
                webResource = webResource.queryParam("overriddenstatus", new Object[]{overriddenStatus.name()});
            }
            Invocation.Builder requestBuilder = webResource.request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            response = requestBuilder.put(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
            EurekaHttpResponse.EurekaHttpResponseBuilder eurekaResponseBuilder = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), InstanceInfo.class).headers(AbstractJersey2EurekaHttpClient.headersOf(response));
            if (response.hasEntity()) {
                eurekaResponseBuilder.entity(response.readEntity(InstanceInfo.class));
            }
            eurekaHttpResponse = eurekaResponseBuilder.build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id + "/status";
        Response response = null;
        try {
            Invocation.Builder requestBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).queryParam("value", new Object[]{newStatus.name()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.put(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus()).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id + "/status";
        Response response = null;
        try {
            Invocation.Builder requestBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.delete();
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus()).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpResponse<Application> getApplication(String appName) {
        EurekaHttpResponse eurekaHttpResponse;
        String urlPath = "apps/" + appName;
        Response response = null;
        try {
            Invocation.Builder requestBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            Application application = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                application = (Application)response.readEntity(Application.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), application).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        EurekaHttpResponse eurekaHttpResponse;
        Response response = null;
        try {
            WebTarget webTarget = this.jerseyClient.target(this.serviceUrl).path(urlPath);
            if (regions != null && regions.length > 0) {
                webTarget = webTarget.queryParam("regions", new Object[]{StringUtil.join((String[])regions)});
            }
            Invocation.Builder requestBuilder = webTarget.request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            Applications applications = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                applications = (Applications)response.readEntity(Applications.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), applications).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + '/' + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        EurekaHttpResponse eurekaHttpResponse;
        Response response = null;
        try {
            Invocation.Builder requestBuilder = this.jerseyClient.target(this.serviceUrl).path(urlPath).request();
            this.addExtraProperties(requestBuilder);
            this.addExtraHeaders(requestBuilder);
            response = requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.readEntity(InstanceInfo.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatus(), infoFromPeer).headers(AbstractJersey2EurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey2 HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    public void shutdown() {
    }

    protected void addExtraProperties(Invocation.Builder webResource) {
        if (this.userName != null) {
            webResource.property("jersey.config.client.http.auth.username", (Object)this.userName).property("jersey.config.client.http.auth.password", (Object)this.password);
        }
    }

    protected abstract void addExtraHeaders(Invocation.Builder var1);

    private static Map<String, String> headersOf(Response response) {
        MultivaluedMap jerseyHeaders = response.getStringHeaders();
        if (jerseyHeaders == null || jerseyHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : jerseyHeaders.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            headers.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return headers;
    }
}

