/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.eureka.EurekaServerConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEurekaServerConfig
implements EurekaServerConfig {
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String TEST = "test";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final Logger logger = LoggerFactory.getLogger(DefaultEurekaServerConfig.class);
    private static final DynamicPropertyFactory configInstance = DynamicPropertyFactory.getInstance();
    private static final DynamicStringProperty EUREKA_PROPS_FILE = DynamicPropertyFactory.getInstance().getStringProperty("eureka.server.props", "eureka-server");
    private static final int TIME_TO_WAIT_FOR_REPLICATION = 30000;
    private String namespace = "eureka.";

    public DefaultEurekaServerConfig() {
        this.init();
    }

    public DefaultEurekaServerConfig(String namespace) {
        this.namespace = namespace;
        this.init();
    }

    private void init() {
        String env = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT, TEST);
        ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)env);
        String eurekaPropsFile = EUREKA_PROPS_FILE.get();
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile);
        }
        catch (IOException e) {
            logger.warn("Cannot find the properties specified : {}. This may be okay if there are other environment specific properties or the configuration is installed with a different mechanism.", (Object)eurekaPropsFile);
        }
    }

    @Override
    public String getAWSAccessId() {
        return configInstance.getStringProperty(this.namespace + "awsAccessId", null).get().trim();
    }

    @Override
    public String getAWSSecretKey() {
        return configInstance.getStringProperty(this.namespace + "awsSecretKey", null).get().trim();
    }

    @Override
    public int getEIPBindRebindRetries() {
        return configInstance.getIntProperty(this.namespace + "eipBindRebindRetries", 3).get();
    }

    @Override
    public int getEIPBindingRetryIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "eipBindRebindRetryIntervalMs", 300000).get();
    }

    @Override
    public boolean shouldEnableSelfPreservation() {
        return configInstance.getBooleanProperty(this.namespace + "enableSelfPreservation", true).get();
    }

    @Override
    public int getPeerEurekaNodesUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "peerEurekaNodesUpdateIntervalMs", 600000).get();
    }

    @Override
    public int getRenewalThresholdUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "renewalThresholdUpdateIntervalMs", 900000).get();
    }

    @Override
    public double getRenewalPercentThreshold() {
        return configInstance.getDoubleProperty(this.namespace + "renewalPercentThreshold", 0.85).get();
    }

    @Override
    public int getNumberOfReplicationRetries() {
        return configInstance.getIntProperty(this.namespace + "numberOfReplicationRetries", 5).get();
    }

    @Override
    public int getPeerEurekaStatusRefreshTimeIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "peerEurekaStatusRefreshTimeIntervalMs", 30000).get();
    }

    @Override
    public int getWaitTimeInMsWhenSyncEmpty() {
        return configInstance.getIntProperty(this.namespace + "waitTimeInMsWhenSyncEmpty", 300000).get();
    }

    @Override
    public int getPeerNodeConnectTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "peerNodeConnectTimeoutMs", 200).get();
    }

    @Override
    public int getPeerNodeReadTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "peerNodeReadTimeoutMs", 200).get();
    }

    @Override
    public int getPeerNodeTotalConnections() {
        return configInstance.getIntProperty(this.namespace + "peerNodeTotalConnections", 1000).get();
    }

    @Override
    public int getPeerNodeTotalConnectionsPerHost() {
        return configInstance.getIntProperty(this.namespace + "peerNodeTotalConnections", 500).get();
    }

    @Override
    public int getPeerNodeConnectionIdleTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "peerNodeConnectionIdleTimeoutSeconds", 30).get();
    }

    @Override
    public long getRetentionTimeInMSInDeltaQueue() {
        return configInstance.getLongProperty(this.namespace + "retentionTimeInMSInDeltaQueue", 180000L).get();
    }

    @Override
    public long getDeltaRetentionTimerIntervalInMs() {
        return configInstance.getLongProperty(this.namespace + "deltaRetentionTimerIntervalInMs", 30000L).get();
    }

    @Override
    public long getEvictionIntervalTimerInMs() {
        return configInstance.getLongProperty(this.namespace + "evictionIntervalTimerInMs", 60000L).get();
    }

    @Override
    public int getASGQueryTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "asgQueryTimeoutMs", 300).get();
    }

    @Override
    public long getASGUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "asgUpdateIntervalMs", 300000).get();
    }

    @Override
    public long getResponseCacheAutoExpirationInSeconds() {
        return configInstance.getIntProperty(this.namespace + "responseCacheAutoExpirationInSeconds", 180).get();
    }

    @Override
    public long getResponseCacheUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "responseCacheUpdateIntervalMs", 30000).get();
    }

    @Override
    public boolean shouldDisableDelta() {
        return configInstance.getBooleanProperty(this.namespace + "disableDelta", false).get();
    }

    @Override
    public long getMaxIdleThreadInMinutesAgeForStatusReplication() {
        return configInstance.getLongProperty(this.namespace + "maxIdleThreadAgeInMinutesForStatusReplication", 10L).get();
    }

    @Override
    public int getMinThreadsForStatusReplication() {
        return configInstance.getIntProperty(this.namespace + "minThreadsForStatusReplication", 1).get();
    }

    @Override
    public int getMaxThreadsForStatusReplication() {
        return configInstance.getIntProperty(this.namespace + "maxThreadsForStatusReplication", 1).get();
    }

    @Override
    public int getMaxElementsInStatusReplicationPool() {
        return configInstance.getIntProperty(this.namespace + "maxElementsInStatusReplicationPool", 10000).get();
    }

    @Override
    public boolean shouldSyncWhenTimestampDiffers() {
        return configInstance.getBooleanProperty(this.namespace + "syncWhenTimestampDiffers", true).get();
    }

    @Override
    public int getRegistrySyncRetries() {
        return configInstance.getIntProperty(this.namespace + "numberRegistrySyncRetries", 5).get();
    }

    @Override
    public int getMaxElementsInPeerReplicationPool() {
        return configInstance.getIntProperty(this.namespace + "maxElementsInPeerReplicationPool", 10000).get();
    }

    @Override
    public long getMaxIdleThreadAgeInMinutesForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "maxIdleThreadAgeInMinutesForPeerReplication", 15).get();
    }

    @Override
    public int getMinThreadsForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "minThreadsForPeerReplication", 5).get();
    }

    @Override
    public int getMaxThreadsForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "maxThreadsForPeerReplication", 20).get();
    }

    @Override
    public int getMaxTimeForReplication() {
        return configInstance.getIntProperty(this.namespace + "maxTimeForReplication", 30000).get();
    }

    @Override
    public boolean shouldPrimeAwsReplicaConnections() {
        return configInstance.getBooleanProperty(this.namespace + "primeAwsReplicaConnections", true).get();
    }
}

