/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EIPManager {
    private static final String US_EAST_1 = "us-east-1";
    private static final Logger logger = LoggerFactory.getLogger(EIPManager.class);
    private EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final EIPManager s_instance = new EIPManager();

    public static EIPManager getInstance() {
        return s_instance;
    }

    private EIPManager() {
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    public void bindToEIP() {
        String myPublicIP;
        String myZone;
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String selectedEIP = this.getCandidateEIP(myInstanceId, myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone), myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4));
        if (selectedEIP == null) {
            logger.debug("No need to bind to EIP");
            return;
        }
        try {
            AmazonEC2 ec2Service = this.getEC2Service();
            AssociateAddressRequest request = new AssociateAddressRequest(myInstanceId, selectedEIP);
            ec2Service.associateAddress(request);
            logger.info("\n\n\nAssociated " + myInstanceId + " running in zone: " + myZone + " to elastic IP: " + selectedEIP);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to bind elastic IP: " + selectedEIP + " to " + myInstanceId, t);
        }
    }

    public void unbindEIP() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myPublicIP = null;
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
            myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
            try {
                AmazonEC2 ec2Service = this.getEC2Service();
                DisassociateAddressRequest dissociateRequest = new DisassociateAddressRequest().withPublicIp(myPublicIP);
                ec2Service.disassociateAddress(dissociateRequest);
                logger.info("Dissociated the EIP {} from this instance", (Object)myPublicIP);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot dissociate address" + myPublicIP + "from this instance", e);
            }
        }
    }

    public String getCandidateEIP(String myInstanceId, String myZone, String myPublicIP) {
        Collection<String> eipCandidates;
        if (myZone == null) {
            myZone = "us-east-1d";
            myPublicIP = "us-east-1d";
        }
        Collection<String> collection = eipCandidates = DiscoveryManager.getInstance().getEurekaClientConfig().shouldUseDnsForFetchingServiceUrls() ? this.getEIPsForZoneFromDNS(myZone) : this.getEIPsForZoneFromConfig(myZone);
        if (eipCandidates == null || eipCandidates.size() == 0) {
            throw new RuntimeException("Could not get any elastic ips from the EIP pool for zone :" + myZone);
        }
        ArrayList<String> availableEIPList = new ArrayList<String>();
        for (String eip : eipCandidates) {
            String eipTrimmed = eip.trim();
            if (myPublicIP.equals(eipTrimmed)) {
                logger.debug("Already bound to an EIP : " + eip);
                return null;
            }
            availableEIPList.add(eipTrimmed);
        }
        InstanceInfo instanceInfo = ApplicationInfoManager.getInstance().getInfo();
        Application app = DiscoveryManager.getInstance().getDiscoveryClient().getApplication(instanceInfo.getAppName());
        if (app != null) {
            for (InstanceInfo i : app.getInstances()) {
                AmazonInfo amazonInfo = (AmazonInfo)i.getDataCenterInfo();
                String publicIP = amazonInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                String instanceId = amazonInfo.get(AmazonInfo.MetaDataKey.instanceId);
                if (instanceId.equals(myInstanceId) && availableEIPList.contains(publicIP)) {
                    logger.warn("The instance id {} is already bound to EIP {}. Hence returning that.", (Object)myInstanceId, (Object)publicIP);
                    return publicIP;
                }
                Iterator it = availableEIPList.iterator();
                while (it.hasNext()) {
                    LeaseInfo leaseInfo;
                    String eip = (String)it.next();
                    if (!eip.trim().equals(publicIP) || (leaseInfo = i.getLeaseInfo()) != null && System.currentTimeMillis() > leaseInfo.getRenewalTimestamp() + (long)(leaseInfo.getDurationInSecs() * 1000)) continue;
                    logger.info("Removing the EIP {} as it is already used by instance {}", (Object)eip, (Object)instanceId);
                    it.remove();
                }
            }
        }
        if (availableEIPList == null || availableEIPList.isEmpty()) {
            throw new RuntimeException("Cannot find a free EIP to bind");
        }
        return (String)availableEIPList.iterator().next();
    }

    private Collection<String> getEIPsForZoneFromConfig(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getEurekaClientConfig().getEurekaServerServiceUrls(myZone);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private Collection<String> getEIPsFromServiceUrls(List<String> ec2Urls) {
        ArrayList<String> returnedUrls = new ArrayList<String>();
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        String regionPhrase = "";
        if (!US_EAST_1.equals(region)) {
            regionPhrase = "." + region;
        }
        for (String cname : ec2Urls) {
            int beginIndex = cname.indexOf("ec2-") + 4;
            int endIndex = cname.indexOf(regionPhrase + ".compute");
            String eipStr = cname.substring(beginIndex, endIndex);
            String eip = eipStr.replaceAll("\\-", ".");
            returnedUrls.add(eip);
        }
        return returnedUrls;
    }

    private Collection<String> getEIPsForZoneFromDNS(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getDiscoveryClient().getServiceUrlsFromDNS(myZone, true);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private AmazonEC2 getEC2Service() {
        this.eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
        AmazonEC2Client ec2Service = new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(this.eurekaConfig.getAWSAccessId(), this.eurekaConfig.getAWSSecretKey()));
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        region = region.trim().toLowerCase();
        ec2Service.setEndpoint("ec2." + region + ".amazonaws.com");
        return ec2Service;
    }
}

