/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.google.common.cache.CacheBuilder;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.Pair;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.InstanceRegistry;
import com.netflix.eureka.registry.RemoteRegionRegistry;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.registry.ResponseCacheImpl;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.util.EurekaMonitors;
import com.netflix.eureka.util.MeasuredRate;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstanceRegistry
implements InstanceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInstanceRegistry.class);
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private final ConcurrentHashMap<String, Map<String, Lease<InstanceInfo>>> registry = new ConcurrentHashMap();
    protected Map<String, RemoteRegionRegistry> regionNameVSRemoteRegistry = new HashMap<String, RemoteRegionRegistry>();
    protected final ConcurrentMap<String, InstanceInfo.InstanceStatus> overriddenInstanceStatusMap = CacheBuilder.newBuilder().initialCapacity(500).expireAfterAccess(1L, TimeUnit.HOURS).build().asMap();
    private final CircularQueue<Pair<Long, String>> recentRegisteredQueue;
    private final CircularQueue<Pair<Long, String>> recentCanceledQueue;
    private ConcurrentLinkedQueue<RecentlyChangedItem> recentlyChangedQueue = new ConcurrentLinkedQueue();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    protected final Object lock = new Object();
    private Timer deltaRetentionTimer = new Timer("Eureka-DeltaRetentionTimer", true);
    private Timer evictionTimer = new Timer("Eureka-EvictionTimer", true);
    private volatile MeasuredRate renewsLastMin;
    private final AtomicReference<EvictionTask> evictionTaskRef = new AtomicReference();
    protected String[] allKnownRemoteRegions = EMPTY_STR_ARRAY;
    protected volatile int numberOfRenewsPerMinThreshold;
    protected volatile int expectedNumberOfRenewsPerMin;
    protected final EurekaServerConfig serverConfig;
    protected final EurekaClientConfig clientConfig;
    protected final ServerCodecs serverCodecs;
    protected volatile ResponseCache responseCache;

    protected AbstractInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs) {
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.serverCodecs = serverCodecs;
        this.recentCanceledQueue = new CircularQueue(1000);
        this.recentRegisteredQueue = new CircularQueue(1000);
        this.deltaRetentionTimer.schedule(this.getDeltaRetentionTask(), serverConfig.getDeltaRetentionTimerIntervalInMs(), serverConfig.getDeltaRetentionTimerIntervalInMs());
    }

    @Override
    public synchronized void initializedResponseCache() {
        if (this.responseCache == null) {
            this.responseCache = new ResponseCacheImpl(this.serverConfig, this.serverCodecs, this);
        }
    }

    protected void initRemoteRegionRegistry() throws MalformedURLException {
        Map<String, String> remoteRegionUrlsWithName = this.serverConfig.getRemoteRegionUrlsWithName();
        if (remoteRegionUrlsWithName != null) {
            this.allKnownRemoteRegions = new String[remoteRegionUrlsWithName.size()];
            int remoteRegionArrayIndex = 0;
            for (Map.Entry<String, String> remoteRegionUrlWithName : remoteRegionUrlsWithName.entrySet()) {
                RemoteRegionRegistry remoteRegionRegistry = new RemoteRegionRegistry(this.serverConfig, this.clientConfig, this.serverCodecs, remoteRegionUrlWithName.getKey(), new URL(remoteRegionUrlWithName.getValue()));
                this.regionNameVSRemoteRegistry.put(remoteRegionUrlWithName.getKey(), remoteRegionRegistry);
                this.allKnownRemoteRegions[remoteRegionArrayIndex++] = remoteRegionUrlWithName.getKey();
            }
        }
        logger.info("Finished initializing remote region registries. All known remote regions: {}", (Object)Arrays.toString(this.allKnownRemoteRegions));
    }

    @Override
    public ResponseCache getResponseCache() {
        return this.responseCache;
    }

    public long getLocalRegistrySize() {
        long total = 0L;
        for (Map<String, Lease<InstanceInfo>> entry : this.registry.values()) {
            total += (long)entry.size();
        }
        return total;
    }

    @Override
    public void clearRegistry() {
        this.overriddenInstanceStatusMap.clear();
        this.recentCanceledQueue.clear();
        this.recentRegisteredQueue.clear();
        this.recentlyChangedQueue.clear();
        this.registry.clear();
    }

    @Override
    public Map<String, InstanceInfo.InstanceStatus> overriddenInstanceStatusesSnapshot() {
        return new HashMap<String, InstanceInfo.InstanceStatus>(this.overriddenInstanceStatusMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(InstanceInfo r, int leaseDuration, boolean isReplication) {
        try {
            InstanceInfo.InstanceStatus overriddenStatusFromMap;
            Serializable registrationLastDirtyTimestamp;
            Object existingLastDirtyTimestamp;
            Lease<InstanceInfo> existingLease;
            this.read.lock();
            ConcurrentHashMap<String, Lease<InstanceInfo>> gMap = this.registry.get(r.getAppName());
            EurekaMonitors.REGISTER.increment(isReplication);
            if (gMap == null) {
                ConcurrentHashMap<String, Lease<InstanceInfo>> gNewMap = new ConcurrentHashMap<String, Lease<InstanceInfo>>();
                gMap = this.registry.putIfAbsent(r.getAppName(), gNewMap);
                if (gMap == null) {
                    gMap = gNewMap;
                }
            }
            if ((existingLease = gMap.get(r.getId())) != null && existingLease.getHolder() != null) {
                existingLastDirtyTimestamp = existingLease.getHolder().getLastDirtyTimestamp();
                registrationLastDirtyTimestamp = r.getLastDirtyTimestamp();
                logger.debug("Existing lease found (existing={}, provided={}", existingLastDirtyTimestamp, (Object)registrationLastDirtyTimestamp);
                if ((Long)existingLastDirtyTimestamp > registrationLastDirtyTimestamp) {
                    logger.warn("There is an existing lease and the existing lease's dirty timestamp {} is greater than the one that is being registered {}", existingLastDirtyTimestamp, (Object)registrationLastDirtyTimestamp);
                    r.setLastDirtyTimestamp((Long)existingLastDirtyTimestamp);
                }
            } else {
                existingLastDirtyTimestamp = this.lock;
                synchronized (existingLastDirtyTimestamp) {
                    if (this.expectedNumberOfRenewsPerMin > 0) {
                        this.expectedNumberOfRenewsPerMin += 2;
                        this.numberOfRenewsPerMinThreshold = (int)((double)this.expectedNumberOfRenewsPerMin * this.serverConfig.getRenewalPercentThreshold());
                    }
                }
                logger.debug("No previous lease information found; it is new registration");
            }
            Lease<InstanceInfo> lease = new Lease<InstanceInfo>(r, leaseDuration);
            if (existingLease != null) {
                lease.setServiceUpTimestamp(existingLease.getServiceUpTimestamp());
            }
            gMap.put(r.getId(), lease);
            registrationLastDirtyTimestamp = this.recentRegisteredQueue;
            synchronized (registrationLastDirtyTimestamp) {
                this.recentRegisteredQueue.add((Pair<Long, String>)new Pair((Object)System.currentTimeMillis(), (Object)(r.getAppName() + "(" + r.getId() + ")")));
            }
            if (!InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)r.getOverriddenStatus())) {
                logger.debug("Found overridden status {} for instance {}. Checking to see if needs to be add to the overrides", (Object)r.getOverriddenStatus(), (Object)r.getId());
                if (!this.overriddenInstanceStatusMap.containsKey(r.getId())) {
                    logger.info("Not found overridden id {} and hence adding it", (Object)r.getId());
                    this.overriddenInstanceStatusMap.put(r.getId(), r.getOverriddenStatus());
                }
            }
            if ((overriddenStatusFromMap = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(r.getId())) != null) {
                logger.info("Storing overridden status {} from map", (Object)overriddenStatusFromMap);
                r.setOverriddenStatus(overriddenStatusFromMap);
            }
            InstanceInfo.InstanceStatus overriddenInstanceStatus = this.getOverriddenInstanceStatus(r, existingLease, isReplication);
            r.setStatusWithoutDirty(overriddenInstanceStatus);
            if (InstanceInfo.InstanceStatus.UP.equals((Object)r.getStatus())) {
                lease.serviceUp();
            }
            r.setActionType(InstanceInfo.ActionType.ADDED);
            this.recentlyChangedQueue.add(new RecentlyChangedItem(lease));
            r.setLastUpdatedTimestamp();
            this.invalidateCache(r.getAppName(), r.getVIPAddress(), r.getSecureVipAddress());
            logger.info("Registered instance {}/{} with status {} (replication={})", new Object[]{r.getAppName(), r.getId(), r.getStatus(), isReplication});
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean cancel(String appName, String id, boolean isReplication) {
        return this.internalCancel(appName, id, isReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalCancel(String appName, String id, boolean isReplication) {
        try {
            this.read.lock();
            EurekaMonitors.CANCEL.increment(isReplication);
            Map<String, Lease<InstanceInfo>> gMap = this.registry.get(appName);
            Lease<InstanceInfo> leaseToCancel = null;
            if (gMap != null) {
                leaseToCancel = gMap.remove(id);
            }
            CircularQueue<Pair<Long, String>> circularQueue = this.recentCanceledQueue;
            synchronized (circularQueue) {
                this.recentCanceledQueue.add((Pair<Long, String>)new Pair((Object)System.currentTimeMillis(), (Object)(appName + "(" + id + ")")));
            }
            InstanceInfo.InstanceStatus instanceStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.remove(id);
            if (instanceStatus != null) {
                logger.debug("Removed instance id {} from the overridden map which has value {}", (Object)id, (Object)instanceStatus.name());
            }
            if (leaseToCancel == null) {
                EurekaMonitors.CANCEL_NOT_FOUND.increment(isReplication);
                logger.warn("DS: Registry: cancel failed because Lease is not registered for: {}/{}", (Object)appName, (Object)id);
                boolean bl = false;
                return bl;
            }
            leaseToCancel.cancel();
            InstanceInfo instanceInfo = leaseToCancel.getHolder();
            String vip = null;
            String svip = null;
            if (instanceInfo != null) {
                instanceInfo.setActionType(InstanceInfo.ActionType.DELETED);
                this.recentlyChangedQueue.add(new RecentlyChangedItem(leaseToCancel));
                instanceInfo.setLastUpdatedTimestamp();
                vip = instanceInfo.getVIPAddress();
                svip = instanceInfo.getSecureVipAddress();
            }
            this.invalidateCache(appName, vip, svip);
            logger.info("Cancelled instance {}/{} (replication={})", new Object[]{appName, id, isReplication});
            boolean bl = true;
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean renew(String appName, String id, boolean isReplication) {
        EurekaMonitors.RENEW.increment(isReplication);
        Map<String, Lease<InstanceInfo>> gMap = this.registry.get(appName);
        Lease<InstanceInfo> leaseToRenew = null;
        if (gMap != null) {
            leaseToRenew = gMap.get(id);
        }
        if (leaseToRenew == null) {
            EurekaMonitors.RENEW_NOT_FOUND.increment(isReplication);
            logger.warn("DS: Registry: lease doesn't exist, registering resource: {} - {}", (Object)appName, (Object)id);
            return false;
        }
        InstanceInfo instanceInfo = (InstanceInfo)leaseToRenew.getHolder();
        if (instanceInfo != null) {
            InstanceInfo.InstanceStatus overriddenInstanceStatus = this.getOverriddenInstanceStatus(instanceInfo, leaseToRenew, isReplication);
            if (overriddenInstanceStatus == InstanceInfo.InstanceStatus.UNKNOWN) {
                logger.info("Instance status UNKNOWN possibly due to deleted override for instance {}; re-register required", (Object)instanceInfo.getId());
                EurekaMonitors.RENEW_NOT_FOUND.increment(isReplication);
                return false;
            }
            if (!instanceInfo.getStatus().equals((Object)overriddenInstanceStatus)) {
                Object[] args = new Object[]{instanceInfo.getStatus().name(), instanceInfo.getOverriddenStatus().name(), instanceInfo.getId()};
                logger.info("The instance status {} is different from overridden instance status {} for instance {}. Hence setting the status to overridden status", args);
                instanceInfo.setStatus(overriddenInstanceStatus);
            }
        }
        this.renewsLastMin.increment();
        leaseToRenew.renew();
        return true;
    }

    @Override
    @Deprecated
    public void storeOverriddenStatusIfRequired(String id, InstanceInfo.InstanceStatus overriddenStatus) {
        InstanceInfo.InstanceStatus instanceStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(id);
        if (instanceStatus == null || !overriddenStatus.equals((Object)instanceStatus)) {
            logger.info("Adding overridden status for instance id {} and the value is {}", (Object)id, (Object)overriddenStatus.name());
            this.overriddenInstanceStatusMap.put(id, overriddenStatus);
            List<InstanceInfo> instanceInfo = this.getInstancesById(id, false);
            if (instanceInfo != null && !instanceInfo.isEmpty()) {
                instanceInfo.iterator().next().setOverriddenStatus(overriddenStatus);
                logger.info("Setting the overridden status for instance id {} and the value is {} ", (Object)id, (Object)overriddenStatus.name());
            }
        }
    }

    @Override
    public void storeOverriddenStatusIfRequired(String appName, String id, InstanceInfo.InstanceStatus overriddenStatus) {
        InstanceInfo.InstanceStatus instanceStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(id);
        if (instanceStatus == null || !overriddenStatus.equals((Object)instanceStatus)) {
            logger.info("Adding overridden status for instance id {} and the value is {}", (Object)id, (Object)overriddenStatus.name());
            this.overriddenInstanceStatusMap.put(id, overriddenStatus);
            InstanceInfo instanceInfo = this.getInstanceByAppAndId(appName, id, false);
            instanceInfo.setOverriddenStatus(overriddenStatus);
            logger.info("Set the overridden status for instance (appname:{}, id:{}} and the value is {} ", new Object[]{appName, id, overriddenStatus.name()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        try {
            this.read.lock();
            EurekaMonitors.STATUS_UPDATE.increment(isReplication);
            Map<String, Lease<InstanceInfo>> gMap = this.registry.get(appName);
            Lease<InstanceInfo> lease = null;
            if (gMap != null) {
                lease = gMap.get(id);
            }
            if (lease == null) {
                boolean bl = false;
                return bl;
            }
            lease.renew();
            InstanceInfo info = lease.getHolder();
            if (info == null) {
                logger.error("Found Lease without a holder for instance id {}", (Object)id);
            }
            if (info != null && !info.getStatus().equals((Object)newStatus)) {
                if (InstanceInfo.InstanceStatus.UP.equals((Object)newStatus)) {
                    lease.serviceUp();
                }
                this.overriddenInstanceStatusMap.put(id, newStatus);
                info.setOverriddenStatus(newStatus);
                long replicaDirtyTimestamp = 0L;
                if (lastDirtyTimestamp != null) {
                    replicaDirtyTimestamp = Long.valueOf(lastDirtyTimestamp);
                }
                if (replicaDirtyTimestamp > info.getLastDirtyTimestamp()) {
                    info.setLastDirtyTimestamp(Long.valueOf(replicaDirtyTimestamp));
                    info.setStatusWithoutDirty(newStatus);
                } else {
                    info.setStatus(newStatus);
                }
                info.setActionType(InstanceInfo.ActionType.MODIFIED);
                this.recentlyChangedQueue.add(new RecentlyChangedItem(lease));
                info.setLastUpdatedTimestamp();
                this.invalidateCache(appName, info.getVIPAddress(), info.getSecureVipAddress());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteStatusOverride(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        try {
            InstanceInfo.InstanceStatus currentOverride;
            this.read.lock();
            EurekaMonitors.STATUS_OVERRIDE_DELETE.increment(isReplication);
            Map<String, Lease<InstanceInfo>> gMap = this.registry.get(appName);
            Lease<InstanceInfo> lease = null;
            if (gMap != null) {
                lease = gMap.get(id);
            }
            if (lease == null) {
                boolean bl = false;
                return bl;
            }
            lease.renew();
            InstanceInfo info = lease.getHolder();
            if (info == null) {
                logger.error("Found Lease without a holder for instance id {}", (Object)id);
            }
            if ((currentOverride = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.remove(id)) != null && info != null) {
                info.setOverriddenStatus(InstanceInfo.InstanceStatus.UNKNOWN);
                info.setStatus(newStatus);
                long replicaDirtyTimestamp = 0L;
                if (lastDirtyTimestamp != null) {
                    replicaDirtyTimestamp = Long.valueOf(lastDirtyTimestamp);
                }
                if (replicaDirtyTimestamp > info.getLastDirtyTimestamp()) {
                    info.setLastDirtyTimestamp(Long.valueOf(replicaDirtyTimestamp));
                }
                info.setActionType(InstanceInfo.ActionType.MODIFIED);
                this.recentlyChangedQueue.add(new RecentlyChangedItem(lease));
                info.setLastUpdatedTimestamp();
                this.invalidateCache(appName, info.getVIPAddress(), info.getSecureVipAddress());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void evict() {
        this.evict(0L);
    }

    public void evict(long additionalLeaseMs) {
        logger.debug("Running the evict task");
        if (!this.isLeaseExpirationEnabled()) {
            logger.debug("DS: lease expiration is currently disabled.");
            return;
        }
        ArrayList<Lease<InstanceInfo>> expiredLeases = new ArrayList<Lease<InstanceInfo>>();
        for (Map.Entry<String, Map<String, Lease<InstanceInfo>>> groupEntry : this.registry.entrySet()) {
            Map<String, Lease<InstanceInfo>> leaseMap = groupEntry.getValue();
            if (leaseMap == null) continue;
            for (Map.Entry<String, Lease<InstanceInfo>> leaseEntry : leaseMap.entrySet()) {
                Lease<InstanceInfo> lease = leaseEntry.getValue();
                if (!lease.isExpired(additionalLeaseMs) || lease.getHolder() == null) continue;
                expiredLeases.add(lease);
            }
        }
        boolean experimental = "true".equalsIgnoreCase(this.serverConfig.getExperimental("evict.cancel.disabled"));
        int registrySize = (int)this.getLocalRegistrySize();
        int registrySizeThreshold = (int)((double)registrySize * this.serverConfig.getRenewalPercentThreshold());
        int evictionLimit = registrySize - registrySizeThreshold;
        int toEvict = Math.min(expiredLeases.size(), evictionLimit);
        if (toEvict > 0) {
            logger.info("Evicting {} items (expired={}, evictionLimit={})", new Object[]{toEvict, expiredLeases.size(), evictionLimit});
            Random random = new Random(System.currentTimeMillis());
            for (int i = 0; i < toEvict; ++i) {
                int next = i + random.nextInt(expiredLeases.size() - i);
                Collections.swap(expiredLeases, i, next);
                Lease lease = (Lease)expiredLeases.get(i);
                String appName = ((InstanceInfo)lease.getHolder()).getAppName();
                String id = ((InstanceInfo)lease.getHolder()).getId();
                EurekaMonitors.EXPIRED.increment();
                logger.warn("DS: Registry: expired lease for {}/{}", (Object)appName, (Object)id);
                if (experimental) {
                    this.internalCancel(appName, id, false);
                    continue;
                }
                this.cancel(appName, id, false);
            }
        }
    }

    public Application getApplication(String appName) {
        boolean disableTransparentFallback = this.serverConfig.disableTransparentFallbackToOtherRegion();
        return this.getApplication(appName, !disableTransparentFallback);
    }

    @Override
    public Application getApplication(String appName, boolean includeRemoteRegion) {
        Application app;
        block4: {
            block3: {
                app = null;
                Map<String, Lease<InstanceInfo>> leaseMap = this.registry.get(appName);
                if (leaseMap == null || leaseMap.size() <= 0) break block3;
                for (Map.Entry<String, Lease<InstanceInfo>> entry : leaseMap.entrySet()) {
                    if (app == null) {
                        app = new Application(appName);
                    }
                    app.addInstance(this.decorateInstanceInfo(entry.getValue()));
                }
                break block4;
            }
            if (!includeRemoteRegion) break block4;
            for (RemoteRegionRegistry remoteRegistry : this.regionNameVSRemoteRegistry.values()) {
                Application application = remoteRegistry.getApplication(appName);
                if (application == null) continue;
                return application;
            }
        }
        return app;
    }

    public Applications getApplications() {
        boolean disableTransparentFallback = this.serverConfig.disableTransparentFallbackToOtherRegion();
        if (disableTransparentFallback) {
            return this.getApplicationsFromLocalRegionOnly();
        }
        return this.getApplicationsFromAllRemoteRegions();
    }

    public Applications getApplicationsFromAllRemoteRegions() {
        return this.getApplicationsFromMultipleRegions(this.allKnownRemoteRegions);
    }

    @Override
    public Applications getApplicationsFromLocalRegionOnly() {
        return this.getApplicationsFromMultipleRegions(EMPTY_STR_ARRAY);
    }

    public Applications getApplicationsFromMultipleRegions(String[] remoteRegions) {
        boolean includeRemoteRegion = null != remoteRegions && remoteRegions.length != 0;
        logger.debug("Fetching applications registry with remote regions: {}, Regions argument {}", (Object)includeRemoteRegion, (Object)Arrays.toString(remoteRegions));
        if (includeRemoteRegion) {
            EurekaMonitors.GET_ALL_WITH_REMOTE_REGIONS_CACHE_MISS.increment();
        } else {
            EurekaMonitors.GET_ALL_CACHE_MISS.increment();
        }
        Applications apps = new Applications();
        apps.setVersion(Long.valueOf(1L));
        for (Map.Entry<String, Map<String, Lease<InstanceInfo>>> entry : this.registry.entrySet()) {
            Application app = null;
            if (entry.getValue() != null) {
                for (Map.Entry<String, Lease<InstanceInfo>> stringLeaseEntry : entry.getValue().entrySet()) {
                    Lease<InstanceInfo> lease = stringLeaseEntry.getValue();
                    if (app == null) {
                        app = new Application(lease.getHolder().getAppName());
                    }
                    app.addInstance(this.decorateInstanceInfo(lease));
                }
            }
            if (app == null) continue;
            apps.addApplication(app);
        }
        if (includeRemoteRegion) {
            for (String remoteRegion : remoteRegions) {
                RemoteRegionRegistry remoteRegistry = this.regionNameVSRemoteRegistry.get(remoteRegion);
                if (null != remoteRegistry) {
                    Applications remoteApps = remoteRegistry.getApplications();
                    for (Application application : remoteApps.getRegisteredApplications()) {
                        if (this.shouldFetchFromRemoteRegistry(application.getName(), remoteRegion)) {
                            logger.info("Application {}  fetched from the remote region {}", (Object)application.getName(), (Object)remoteRegion);
                            Application appInstanceTillNow = apps.getRegisteredApplications(application.getName());
                            if (appInstanceTillNow == null) {
                                appInstanceTillNow = new Application(application.getName());
                                apps.addApplication(appInstanceTillNow);
                            }
                            for (InstanceInfo instanceInfo : application.getInstances()) {
                                appInstanceTillNow.addInstance(instanceInfo);
                            }
                            continue;
                        }
                        logger.debug("Application {} not fetched from the remote region {} as there exists a whitelist and this app is not in the whitelist.", (Object)application.getName(), (Object)remoteRegion);
                    }
                    continue;
                }
                logger.warn("No remote registry available for the remote region {}", (Object)remoteRegion);
            }
        }
        apps.setAppsHashCode(apps.getReconcileHashCode());
        return apps;
    }

    private boolean shouldFetchFromRemoteRegistry(String appName, String remoteRegion) {
        Set<String> whiteList = this.serverConfig.getRemoteRegionAppWhitelist(remoteRegion);
        if (null == whiteList) {
            whiteList = this.serverConfig.getRemoteRegionAppWhitelist(null);
        }
        return null == whiteList || whiteList.contains(appName);
    }

    @Deprecated
    public Applications getApplications(boolean includeRemoteRegion) {
        EurekaMonitors.GET_ALL_CACHE_MISS.increment();
        Applications apps = new Applications();
        apps.setVersion(Long.valueOf(1L));
        for (Map.Entry<String, Map<String, Lease<InstanceInfo>>> entry : this.registry.entrySet()) {
            Application app = null;
            if (entry.getValue() != null) {
                for (Map.Entry<String, Lease<InstanceInfo>> stringLeaseEntry : entry.getValue().entrySet()) {
                    Lease<InstanceInfo> lease = stringLeaseEntry.getValue();
                    if (app == null) {
                        app = new Application(lease.getHolder().getAppName());
                    }
                    app.addInstance(this.decorateInstanceInfo(lease));
                }
            }
            if (app == null) continue;
            apps.addApplication(app);
        }
        if (includeRemoteRegion) {
            for (RemoteRegionRegistry remoteRegistry : this.regionNameVSRemoteRegistry.values()) {
                Applications applications = remoteRegistry.getApplications();
                for (Application application : applications.getRegisteredApplications()) {
                    Application appInLocalRegistry = apps.getRegisteredApplications(application.getName());
                    if (appInLocalRegistry != null) continue;
                    apps.addApplication(application);
                }
            }
        }
        apps.setAppsHashCode(apps.getReconcileHashCode());
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Applications getApplicationDeltas() {
        EurekaMonitors.GET_ALL_CACHE_MISS_DELTA.increment();
        Applications apps = new Applications();
        apps.setVersion(Long.valueOf(this.responseCache.getVersionDelta().get()));
        HashMap<String, Application> applicationInstancesMap = new HashMap<String, Application>();
        try {
            this.write.lock();
            Iterator<RecentlyChangedItem> iter = this.recentlyChangedQueue.iterator();
            logger.debug("The number of elements in the delta queue is :" + this.recentlyChangedQueue.size());
            while (iter.hasNext()) {
                Lease<InstanceInfo> lease = iter.next().getLeaseInfo();
                InstanceInfo instanceInfo = lease.getHolder();
                Object[] args = new Object[]{instanceInfo.getId(), instanceInfo.getStatus().name(), instanceInfo.getActionType().name()};
                logger.debug("The instance id %s is found with status %s and actiontype %s", args);
                Application app = (Application)applicationInstancesMap.get(instanceInfo.getAppName());
                if (app == null) {
                    app = new Application(instanceInfo.getAppName());
                    applicationInstancesMap.put(instanceInfo.getAppName(), app);
                    apps.addApplication(app);
                }
                app.addInstance(this.decorateInstanceInfo(lease));
            }
            boolean disableTransparentFallback = this.serverConfig.disableTransparentFallbackToOtherRegion();
            if (!disableTransparentFallback) {
                Applications allAppsInLocalRegion = this.getApplications(false);
                for (RemoteRegionRegistry remoteRegistry : this.regionNameVSRemoteRegistry.values()) {
                    Applications applications = remoteRegistry.getApplicationDeltas();
                    for (Application application : applications.getRegisteredApplications()) {
                        Application appInLocalRegistry = allAppsInLocalRegion.getRegisteredApplications(application.getName());
                        if (appInLocalRegistry != null) continue;
                        apps.addApplication(application);
                    }
                }
            }
            Applications allApps = this.getApplications(!disableTransparentFallback);
            apps.setAppsHashCode(allApps.getReconcileHashCode());
            Applications applications = apps;
            return applications;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applications getApplicationDeltasFromMultipleRegions(String[] remoteRegions) {
        boolean includeRemoteRegion;
        if (null == remoteRegions) {
            remoteRegions = this.allKnownRemoteRegions;
        }
        boolean bl = includeRemoteRegion = remoteRegions.length != 0;
        if (includeRemoteRegion) {
            EurekaMonitors.GET_ALL_WITH_REMOTE_REGIONS_CACHE_MISS_DELTA.increment();
        } else {
            EurekaMonitors.GET_ALL_CACHE_MISS_DELTA.increment();
        }
        Applications apps = new Applications();
        apps.setVersion(Long.valueOf(this.responseCache.getVersionDeltaWithRegions().get()));
        HashMap<String, Application> applicationInstancesMap = new HashMap<String, Application>();
        try {
            this.write.lock();
            Iterator<RecentlyChangedItem> iter = this.recentlyChangedQueue.iterator();
            logger.debug("The number of elements in the delta queue is :" + this.recentlyChangedQueue.size());
            while (iter.hasNext()) {
                Lease<InstanceInfo> lease = iter.next().getLeaseInfo();
                InstanceInfo instanceInfo = (InstanceInfo)lease.getHolder();
                Object[] args = new Object[]{instanceInfo.getId(), instanceInfo.getStatus().name(), instanceInfo.getActionType().name()};
                logger.debug("The instance id %s is found with status %s and actiontype %s", args);
                Application app = (Application)applicationInstancesMap.get(instanceInfo.getAppName());
                if (app == null) {
                    app = new Application(instanceInfo.getAppName());
                    applicationInstancesMap.put(instanceInfo.getAppName(), app);
                    apps.addApplication(app);
                }
                app.addInstance(this.decorateInstanceInfo(lease));
            }
            if (includeRemoteRegion) {
                for (String remoteRegion : remoteRegions) {
                    Applications remoteAppsDelta;
                    RemoteRegionRegistry remoteRegistry = this.regionNameVSRemoteRegistry.get(remoteRegion);
                    if (null == remoteRegistry || null == (remoteAppsDelta = remoteRegistry.getApplicationDeltas())) continue;
                    for (Application application : remoteAppsDelta.getRegisteredApplications()) {
                        if (!this.shouldFetchFromRemoteRegistry(application.getName(), remoteRegion)) continue;
                        Application appInstanceTillNow = apps.getRegisteredApplications(application.getName());
                        if (appInstanceTillNow == null) {
                            appInstanceTillNow = new Application(application.getName());
                            apps.addApplication(appInstanceTillNow);
                        }
                        for (InstanceInfo instanceInfo : application.getInstances()) {
                            appInstanceTillNow.addInstance(instanceInfo);
                        }
                    }
                }
            }
            Applications allApps = this.getApplicationsFromMultipleRegions(remoteRegions);
            apps.setAppsHashCode(allApps.getReconcileHashCode());
            Applications applications = apps;
            return applications;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public InstanceInfo getInstanceByAppAndId(String appName, String id) {
        return this.getInstanceByAppAndId(appName, id, true);
    }

    @Override
    public InstanceInfo getInstanceByAppAndId(String appName, String id, boolean includeRemoteRegions) {
        Map<String, Lease<InstanceInfo>> leaseMap = this.registry.get(appName);
        Lease<InstanceInfo> lease = null;
        if (leaseMap != null) {
            lease = leaseMap.get(id);
        }
        if (!(lease == null || this.isLeaseExpirationEnabled() && lease.isExpired())) {
            return this.decorateInstanceInfo(lease);
        }
        if (includeRemoteRegions) {
            for (RemoteRegionRegistry remoteRegistry : this.regionNameVSRemoteRegistry.values()) {
                Application application = remoteRegistry.getApplication(appName);
                if (application == null) continue;
                return application.getByInstanceId(id);
            }
        }
        return null;
    }

    @Deprecated
    public List<InstanceInfo> getInstancesById(String id) {
        return this.getInstancesById(id, true);
    }

    @Deprecated
    public List<InstanceInfo> getInstancesById(String id, boolean includeRemoteRegions) {
        ArrayList<Object> list = new ArrayList<InstanceInfo>();
        Iterator<Map.Entry<String, Map<String, Lease<InstanceInfo>>>> iter = this.registry.entrySet().iterator();
        while (iter.hasNext()) {
            Lease<InstanceInfo> lease;
            Map<String, Lease<InstanceInfo>> leaseMap = iter.next().getValue();
            if (leaseMap == null || (lease = leaseMap.get(id)) == null || this.isLeaseExpirationEnabled() && lease.isExpired()) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList();
            }
            list.add(this.decorateInstanceInfo(lease));
        }
        if (list.isEmpty() && includeRemoteRegions) {
            for (RemoteRegionRegistry remoteRegistry : this.regionNameVSRemoteRegistry.values()) {
                for (Application application : remoteRegistry.getApplications().getRegisteredApplications()) {
                    InstanceInfo instanceInfo = application.getByInstanceId(id);
                    if (instanceInfo == null) continue;
                    list.add(instanceInfo);
                    return list;
                }
            }
        }
        return list;
    }

    private InstanceInfo decorateInstanceInfo(Lease<InstanceInfo> lease) {
        InstanceInfo info = lease.getHolder();
        int renewalInterval = 30;
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null) {
            renewalInterval = info.getLeaseInfo().getRenewalIntervalInSecs();
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        info.setLeaseInfo(LeaseInfo.Builder.newBuilder().setRegistrationTimestamp(lease.getRegistrationTimestamp()).setRenewalTimestamp(lease.getLastRenewalTimestamp()).setServiceUpTimestamp(lease.getServiceUpTimestamp()).setRenewalIntervalInSecs(renewalInterval).setDurationInSecs(leaseDuration).setEvictionTimestamp(lease.getEvictionTimestamp()).build());
        info.setIsCoordinatingDiscoveryServer();
        return info;
    }

    @Override
    @Monitor(name="numOfRenewsInLastMin", description="Number of total heartbeats received in the last minute", type=DataSourceType.GAUGE)
    public long getNumOfRenewsInLastMin() {
        if (this.renewsLastMin != null) {
            return this.renewsLastMin.getCount();
        }
        return 0L;
    }

    @Override
    @Monitor(name="numOfRenewsPerMinThreshold", type=DataSourceType.GAUGE)
    public int getNumOfRenewsPerMinThreshold() {
        return this.numberOfRenewsPerMinThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<Long, String>> getLastNRegisteredInstances() {
        ArrayList<Pair<Long, String>> list = new ArrayList<Pair<Long, String>>();
        CircularQueue<Pair<Long, String>> circularQueue = this.recentRegisteredQueue;
        synchronized (circularQueue) {
            for (Pair pair : this.recentRegisteredQueue) {
                list.add(pair);
            }
        }
        Collections.reverse(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<Long, String>> getLastNCanceledInstances() {
        ArrayList<Pair<Long, String>> list = new ArrayList<Pair<Long, String>>();
        CircularQueue<Pair<Long, String>> circularQueue = this.recentCanceledQueue;
        synchronized (circularQueue) {
            for (Pair pair : this.recentCanceledQueue) {
                list.add(pair);
            }
        }
        Collections.reverse(list);
        return list;
    }

    private void invalidateCache(String appName, @Nullable String vipAddress, @Nullable String secureVipAddress) {
        this.responseCache.invalidate(appName, vipAddress, secureVipAddress);
    }

    protected void postInit() {
        this.renewsLastMin = new MeasuredRate(60000L);
        if (this.evictionTaskRef.get() != null) {
            this.evictionTaskRef.get().cancel();
        }
        this.evictionTaskRef.set(new EvictionTask());
        this.evictionTimer.schedule((TimerTask)this.evictionTaskRef.get(), this.serverConfig.getEvictionIntervalTimerInMs(), this.serverConfig.getEvictionIntervalTimerInMs());
    }

    @Override
    public void shutdown() {
        this.deltaRetentionTimer.cancel();
        this.evictionTimer.cancel();
    }

    @Monitor(name="numOfElementsinInstanceCache", description="Number of overrides in the instance Cache", type=DataSourceType.GAUGE)
    public long getNumberofElementsininstanceCache() {
        return this.overriddenInstanceStatusMap.size();
    }

    protected abstract InstanceInfo.InstanceStatus getOverriddenInstanceStatus(InstanceInfo var1, Lease<InstanceInfo> var2, boolean var3);

    private TimerTask getDeltaRetentionTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Iterator it = AbstractInstanceRegistry.this.recentlyChangedQueue.iterator();
                while (it.hasNext() && ((RecentlyChangedItem)it.next()).getLastUpdateTime() < System.currentTimeMillis() - AbstractInstanceRegistry.this.serverConfig.getRetentionTimeInMSInDeltaQueue()) {
                    it.remove();
                }
            }
        };
    }

    private class CircularQueue<E>
    extends ConcurrentLinkedQueue<E> {
        private int size = 0;

        public CircularQueue(int size) {
            this.size = size;
        }

        @Override
        public boolean add(E e) {
            this.makeSpaceIfNotAvailable();
            return super.add(e);
        }

        private void makeSpaceIfNotAvailable() {
            if (this.size() == this.size) {
                this.remove();
            }
        }

        @Override
        public boolean offer(E e) {
            this.makeSpaceIfNotAvailable();
            return super.offer(e);
        }
    }

    class EvictionTask
    extends TimerTask {
        private final AtomicLong lastExecutionNanosRef = new AtomicLong(0L);

        EvictionTask() {
        }

        @Override
        public void run() {
            try {
                boolean experimental = "true".equalsIgnoreCase(AbstractInstanceRegistry.this.serverConfig.getExperimental("evict.compensateForDelays"));
                if (experimental) {
                    long compensationTimeMs = this.getCompensationTimeMs();
                    logger.info("Running the evict task with compensationTime {}ms", (Object)compensationTimeMs);
                    AbstractInstanceRegistry.this.evict(compensationTimeMs);
                } else {
                    AbstractInstanceRegistry.this.evict();
                }
            }
            catch (Throwable e) {
                logger.error("Could not run the evict task", e);
            }
        }

        long getCompensationTimeMs() {
            long currNanos = this.getCurrentTimeNano();
            long lastNanos = this.lastExecutionNanosRef.getAndSet(currNanos);
            if (lastNanos == 0L) {
                return 0L;
            }
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(currNanos - lastNanos);
            long compensationTime = elapsedMs - AbstractInstanceRegistry.this.serverConfig.getEvictionIntervalTimerInMs();
            return compensationTime <= 0L ? 0L : compensationTime;
        }

        long getCurrentTimeNano() {
            return System.nanoTime();
        }
    }

    private static final class RecentlyChangedItem {
        private long lastUpdateTime;
        private Lease<InstanceInfo> leaseInfo;

        public RecentlyChangedItem(Lease<InstanceInfo> lease) {
            this.leaseInfo = lease;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public Lease<InstanceInfo> getLeaseInfo() {
            return this.leaseInfo;
        }
    }
}

