/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.LookupService;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.StaticClusterResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRegionRegistry
implements LookupService<String> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRegionRegistry.class);
    private final Timer fetchRegistryTimer;
    private final URL remoteRegionURL;
    private final ScheduledExecutorService scheduler;
    private final AtomicLong fetchRegistryGeneration = new AtomicLong(0L);
    private final Lock fetchRegistryUpdateLock = new ReentrantLock();
    private final AtomicReference<Applications> applications = new AtomicReference<Applications>(new Applications());
    private final AtomicReference<Applications> applicationsDelta = new AtomicReference<Applications>(new Applications());
    private final EurekaServerConfig serverConfig;
    private volatile boolean readyForServingData;
    private final EurekaHttpClient eurekaHttpClient;
    private long timeOfLastSuccessfulRemoteFetch = System.currentTimeMillis();
    private long deltaSuccesses = 0L;
    private long deltaMismatches = 0L;

    @Inject
    public RemoteRegionRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaServerHttpClientFactory eurekaServerHttpClientFactory, String regionName, URL remoteRegionURL) {
        this.serverConfig = serverConfig;
        this.remoteRegionURL = remoteRegionURL;
        this.fetchRegistryTimer = Monitors.newTimer((String)(this.remoteRegionURL.toString() + "_FetchRegistry"));
        EurekaHttpClient newEurekaHttpClient = null;
        try {
            ClusterResolver clusterResolver = StaticClusterResolver.fromURL((String)regionName, (URL)remoteRegionURL);
            newEurekaHttpClient = eurekaServerHttpClientFactory.createRemoteRegionClient(serverConfig, clientConfig.getTransportConfig(), serverCodecs, (ClusterResolver<EurekaEndpoint>)clusterResolver);
        }
        catch (Exception e) {
            throw new RuntimeException("Transport initialization failure", e);
        }
        this.eurekaHttpClient = newEurekaHttpClient;
        try {
            if (this.fetchRegistry()) {
                this.readyForServingData = true;
            } else {
                logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
            }
        }
        catch (Throwable e) {
            logger.error("Problem fetching registry information :", e);
        }
        Runnable remoteRegionFetchTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (RemoteRegionRegistry.this.fetchRegistry()) {
                        RemoteRegionRegistry.this.readyForServingData = true;
                    } else {
                        logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
                    }
                }
                catch (Throwable e) {
                    logger.error("Error getting from remote registry :", e);
                }
            }
        };
        ThreadPoolExecutor remoteRegionFetchExecutor = new ThreadPoolExecutor(1, serverConfig.getRemoteRegionFetchThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Eureka-RemoteRegionCacheRefresher_" + regionName + "-%d").setDaemon(true).build());
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("RemoteRegionFetch_" + regionName, this.scheduler, remoteRegionFetchExecutor, serverConfig.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS, 5, remoteRegionFetchTask), (long)serverConfig.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS);
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the RemoteRegionRegistry :", e);
        }
    }

    public boolean isReadyForServingData() {
        return this.readyForServingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchRegistry() {
        boolean success;
        Stopwatch tracer = this.fetchRegistryTimer.start();
        try {
            if (this.serverConfig.shouldDisableDeltaForRemoteRegions() || this.getApplications() == null || this.getApplications().getRegisteredApplications().size() == 0) {
                logger.info("Disable delta property : {}", (Object)this.serverConfig.shouldDisableDeltaForRemoteRegions());
                logger.info("Application is null : {}", (Object)(this.getApplications() == null ? 1 : 0));
                logger.info("Registered Applications size is zero : {}", (Object)this.getApplications().getRegisteredApplications().isEmpty());
                success = this.storeFullRegistry();
            } else {
                success = this.fetchAndStoreDelta();
            }
            this.logTotalInstances();
        }
        catch (Throwable e) {
            logger.error("Unable to fetch registry information from the remote registry {}", (Object)this.remoteRegionURL, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
        if (success) {
            this.timeOfLastSuccessfulRemoteFetch = System.currentTimeMillis();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchAndStoreDelta() throws Throwable {
        long currGeneration = this.fetchRegistryGeneration.get();
        Applications delta = this.fetchRemoteRegistry(true);
        if (delta == null) {
            logger.error("The delta is null for some reason. Not storing this information");
        } else if (this.fetchRegistryGeneration.compareAndSet(currGeneration, currGeneration + 1L)) {
            this.applicationsDelta.set(delta);
        } else {
            delta = null;
            logger.warn("Not updating delta as another thread is updating it already");
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            return this.storeFullRegistry();
        }
        String reconcileHashCode = "";
        if (this.fetchRegistryUpdateLock.tryLock()) {
            try {
                this.updateDelta(delta);
                reconcileHashCode = this.getApplications().getReconcileHashCode();
            }
            finally {
                this.fetchRegistryUpdateLock.unlock();
            }
        } else {
            logger.warn("Cannot acquire update lock, aborting updateDelta operation of fetchAndStoreDelta");
        }
        if (!reconcileHashCode.equals(delta.getAppsHashCode())) {
            ++this.deltaMismatches;
            return this.reconcileAndLogDifference(delta, reconcileHashCode);
        }
        ++this.deltaSuccesses;
        return delta != null;
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    this.getApplications().addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                this.getApplications().getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
    }

    private void closeResponse(Object response) {
        if (response != null) {
            // empty if block
        }
    }

    public boolean storeFullRegistry() {
        long currentGeneration = this.fetchRegistryGeneration.get();
        Applications apps = this.fetchRemoteRegistry(false);
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else {
            if (this.fetchRegistryGeneration.compareAndSet(currentGeneration, currentGeneration + 1L)) {
                this.applications.set(apps);
                this.applicationsDelta.set(apps);
                logger.info("Successfully updated registry with the latest content");
                return true;
            }
            logger.warn("Not updating applications as another thread is updating it already");
        }
        return false;
    }

    protected Applications fetchRemoteRegistry(boolean delta) {
        logger.info("Getting instance registry info from the eureka server : {} , delta : {}", (Object)this.remoteRegionURL, (Object)delta);
        try {
            EurekaHttpResponse httpResponse = delta ? this.eurekaHttpClient.getDelta(new String[0]) : this.eurekaHttpClient.getApplications(new String[0]);
            int httpStatus = httpResponse.getStatusCode();
            if (httpStatus >= 200 && httpStatus < 300) {
                logger.debug("Got the data successfully : {}", (Object)httpStatus);
                return (Applications)httpResponse.getEntity();
            }
            logger.warn("Cannot get the data from {} : {}", (Object)this.remoteRegionURL, (Object)httpStatus);
        }
        catch (Throwable t) {
            logger.error("Can't get a response from {}", (Object)this.remoteRegionURL, (Object)t);
        }
        return null;
    }

    private boolean reconcileAndLogDifference(Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        long currentGeneration = this.fetchRegistryGeneration.get();
        Applications apps = this.fetchRemoteRegistry(false);
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
            return false;
        }
        if (this.fetchRegistryGeneration.compareAndSet(currentGeneration, currentGeneration + 1L)) {
            this.applications.set(apps);
            this.applicationsDelta.set(apps);
            logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
            return true;
        }
        logger.warn("Not setting the applications map as another thread has advanced the update generation");
        return true;
    }

    private void logTotalInstances() {
        int totInstances = 0;
        for (Application application : this.getApplications().getRegisteredApplications()) {
            totInstances += application.getInstancesAsIsFromEureka().size();
        }
        logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
    }

    public Applications getApplications() {
        return this.applications.get();
    }

    public InstanceInfo getNextServerFromEureka(String arg0, boolean arg1) {
        return null;
    }

    public Application getApplication(String appName) {
        return this.applications.get().getRegisteredApplications(appName);
    }

    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> list = new ArrayList<InstanceInfo>(1);
        for (Application app : this.applications.get().getRegisteredApplications()) {
            InstanceInfo info = app.getByInstanceId(id);
            if (info == null) continue;
            list.add(info);
            return list;
        }
        return Collections.emptyList();
    }

    public Applications getApplicationDeltas() {
        return this.applicationsDelta.get();
    }

    @Monitor(name="eurekaServer.registry.secondsSinceLastSuccessfulRemoteFetch", type=DataSourceType.GAUGE)
    public long getTimeOfLastSuccessfulRemoteFetch() {
        return (System.currentTimeMillis() - this.timeOfLastSuccessfulRemoteFetch) / 1000L;
    }

    @Monitor(name="eurekaServer.registry.remoteDeltaSuccesses", type=DataSourceType.COUNTER)
    public long getRemoteFetchSuccesses() {
        return this.deltaSuccesses;
    }

    @Monitor(name="eurekaServer.registry.remoteDeltaMismatches", type=DataSourceType.COUNTER)
    public long getRemoteFetchMismatches() {
        return this.deltaMismatches;
    }
}

